/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.module.planet.mixin.gravity;

import dev.amble.ait.core.AITDimensions;
import dev.amble.ait.core.AITStatusEffects;
import dev.amble.ait.core.entities.FlightTardisEntity;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.world.TardisServerWorld;
import dev.amble.ait.data.Loyalty;
import dev.amble.ait.module.planet.core.space.planet.Planet;
import dev.amble.ait.module.planet.core.space.planet.PlanetRegistry;
import dev.amble.ait.module.planet.core.util.ISpaceImmune;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3483;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class}, priority=1001)
public abstract class LivingEntityMixin
extends class_1297 {
    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"tickMovement"}, at={@At(value="TAIL")})
    public void ait$tickMovement(CallbackInfo ci) {
        if (!this.method_5787()) {
            return;
        }
        Planet planet = PlanetRegistry.getInstance().get(this.method_37908());
        if (planet == null || !planet.hasGravityModifier()) {
            return;
        }
        class_1309 entity = (class_1309)this;
        if (entity.method_5681() || entity.method_5740() || entity.method_7325()) {
            return;
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_31549().field_7479) {
                return;
            }
        }
        if (entity.method_5864() == class_1299.field_6121 || entity.method_5864() == class_1299.field_38096) {
            return;
        }
        boolean oxygenated = entity.method_6059(AITStatusEffects.OXYGENATED);
        if (oxygenated) {
            return;
        }
        class_243 movement = entity.method_18798();
        entity.method_18800(movement.field_1352, movement.field_1351 + (double)planet.gravity(), movement.field_1350);
    }

    @Inject(method={"tickInVoid"}, at={@At(value="HEAD")}, cancellable=true)
    public void ait$tickInVoid(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (entity instanceof FlightTardisEntity) {
            ci.cancel();
        }
        if (entity.method_37908().method_27983().equals(AITDimensions.SPACE)) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void ait$tick(CallbackInfo ci) {
        class_1657 player;
        class_1657 player2;
        if (this.field_6012 % 10 != 0) {
            return;
        }
        class_1309 entity = (class_1309)this;
        Planet planet = PlanetRegistry.getInstance().get(this.method_37908());
        if (planet == null) {
            return;
        }
        if (entity instanceof class_1657 && (player2 = (class_1657)entity).method_7325()) {
            return;
        }
        boolean oxygenated = entity.method_6059(AITStatusEffects.OXYGENATED);
        if (oxygenated) {
            return;
        }
        if (entity instanceof ISpaceImmune) {
            return;
        }
        if (entity instanceof class_1657 && (player = (class_1657)entity).method_7337()) {
            return;
        }
        if (planet.isFreezing() && !Planet.hasFullSuit(entity)) {
            if (entity.method_5864().method_20210(class_3483.field_29825)) {
                return;
            }
            if (entity.method_32312() < entity.method_32315()) {
                entity.method_32317(entity.method_32315() + 20);
            }
        }
        if (!(planet.hasOxygen() || Planet.hasFullSuit(entity) || Planet.hasOxygenInTank(entity))) {
            entity.method_6092(new class_1293(class_1294.field_5916, 200, 1, false, false));
            entity.method_6092(new class_1293(class_1294.field_5920, 1, 200, false, false));
            entity.method_6092(new class_1293(class_1294.field_5911, 200, 1, false, false));
        }
    }

    @Inject(method={"handleFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void ait$handleFallDamage(float fallDistance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        class_1937 world = this.method_37908();
        Planet planet = PlanetRegistry.getInstance().get(world);
        if (planet != null) {
            if (planet.hasNoFallDamage()) {
                cir.setReturnValue((Object)false);
            }
            return;
        }
        class_1309 entity = (class_1309)this;
        if (world instanceof TardisServerWorld) {
            TardisServerWorld tardisWorld = (TardisServerWorld)world;
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                ServerTardis tardis = tardisWorld.getTardis();
                boolean hasLifeSupport = tardis.subsystems().lifeSupport().isUsable();
                if (hasLifeSupport && tardis.loyalty().get(player).isOf(Loyalty.Type.OWNER)) {
                    cir.setReturnValue((Object)false);
                }
            }
        }
    }
}

