/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.registry.impl;

import dev.amble.ait.AITMod;
import dev.amble.ait.data.datapack.DatapackCategory;
import dev.amble.ait.data.schema.exterior.ExteriorCategorySchema;
import dev.amble.ait.data.schema.exterior.category.AdaptiveCategory;
import dev.amble.ait.data.schema.exterior.category.BookshelfCategory;
import dev.amble.ait.data.schema.exterior.category.BoothCategory;
import dev.amble.ait.data.schema.exterior.category.CapsuleCategory;
import dev.amble.ait.data.schema.exterior.category.ClassicCategory;
import dev.amble.ait.data.schema.exterior.category.DalekModCategory;
import dev.amble.ait.data.schema.exterior.category.EasterHeadCategory;
import dev.amble.ait.data.schema.exterior.category.ExclusiveCategory;
import dev.amble.ait.data.schema.exterior.category.GeometricCategory;
import dev.amble.ait.data.schema.exterior.category.GrowthCategory;
import dev.amble.ait.data.schema.exterior.category.PipeCategory;
import dev.amble.ait.data.schema.exterior.category.PlinthCategory;
import dev.amble.ait.data.schema.exterior.category.PoliceBoxCategory;
import dev.amble.ait.data.schema.exterior.category.RenegadeCategory;
import dev.amble.ait.data.schema.exterior.category.StallionCategory;
import dev.amble.ait.data.schema.exterior.category.TardimCategory;
import dev.amble.lib.register.datapack.SimpleDatapackRegistry;
import java.util.Random;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_3264;

public class CategoryRegistry
extends SimpleDatapackRegistry<ExteriorCategorySchema> {
    private static CategoryRegistry INSTANCE;
    public static ExteriorCategorySchema CLASSIC;
    public static ExteriorCategorySchema CAPSULE;
    public static ExteriorCategorySchema POLICE_BOX;
    public static ExteriorCategorySchema TARDIM;
    public static ExteriorCategorySchema BOOTH;
    public static ExteriorCategorySchema EASTER_HEAD;
    public static ExteriorCategorySchema CORAL_GROWTH;
    public static ExteriorCategorySchema PLINTH;
    public static ExteriorCategorySchema RENEGADE;
    public static ExteriorCategorySchema BOOKSHELF;
    public static ExteriorCategorySchema GEOMETRIC;
    public static ExteriorCategorySchema STALLION;
    public static ExteriorCategorySchema ADAPTIVE;
    public static ExteriorCategorySchema DALEK_MOD;
    public static ExteriorCategorySchema PIPE;
    public static ExteriorCategorySchema EXCLUSIVE;

    protected CategoryRegistry() {
        super(DatapackCategory::fromInputStream, DatapackCategory.CODEC, "categories", true, "ait");
    }

    public void onCommonInit() {
        super.onCommonInit();
        this.defaults();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    public ExteriorCategorySchema fallback() {
        return CAPSULE;
    }

    public ExteriorCategorySchema getRandom(Random random) {
        ExteriorCategorySchema schema = (ExteriorCategorySchema)super.getRandom(random);
        return schema == CORAL_GROWTH ? TARDIM : schema;
    }

    public static CategoryRegistry getInstance() {
        if (INSTANCE == null) {
            AITMod.LOGGER.info("CategoryRegistry was not initialized, Creating a new instance");
            INSTANCE = new CategoryRegistry();
        }
        return INSTANCE;
    }

    protected void defaults() {
        CLASSIC = (ExteriorCategorySchema)this.register(new ClassicCategory());
        CAPSULE = (ExteriorCategorySchema)this.register(new CapsuleCategory());
        POLICE_BOX = (ExteriorCategorySchema)this.register(new PoliceBoxCategory());
        TARDIM = (ExteriorCategorySchema)this.register(new TardimCategory());
        BOOTH = (ExteriorCategorySchema)this.register(new BoothCategory());
        EASTER_HEAD = (ExteriorCategorySchema)this.register(new EasterHeadCategory());
        CORAL_GROWTH = (ExteriorCategorySchema)this.register(new GrowthCategory());
        PLINTH = (ExteriorCategorySchema)this.register(new PlinthCategory());
        RENEGADE = (ExteriorCategorySchema)this.register(new RenegadeCategory());
        BOOKSHELF = (ExteriorCategorySchema)this.register(new BookshelfCategory());
        GEOMETRIC = (ExteriorCategorySchema)this.register(new GeometricCategory());
        STALLION = (ExteriorCategorySchema)this.register(new StallionCategory());
        ADAPTIVE = (ExteriorCategorySchema)this.register(new AdaptiveCategory());
        DALEK_MOD = (ExteriorCategorySchema)this.register(new DalekModCategory());
        PIPE = (ExteriorCategorySchema)this.register(new PipeCategory());
        EXCLUSIVE = (ExteriorCategorySchema)this.register(new ExclusiveCategory());
    }
}

