/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.registry.impl;

import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.data.datapack.DatapackDesktop;
import dev.amble.ait.data.schema.desktop.DefaultCaveDesktop;
import dev.amble.ait.data.schema.desktop.DevDesktop;
import dev.amble.ait.data.schema.desktop.TardisDesktopSchema;
import dev.amble.lib.register.datapack.DatapackRegistry;
import dev.amble.lib.register.unlockable.UnlockableRegistry;
import java.util.Random;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_3264;

public class DesktopRegistry
extends UnlockableRegistry<TardisDesktopSchema> {
    private static final DesktopRegistry INSTANCE = new DesktopRegistry();
    public static TardisDesktopSchema DEFAULT_CAVE;
    public static TardisDesktopSchema DEV;

    protected DesktopRegistry() {
        super(DatapackDesktop::fromInputStream, DatapackDesktop.CODEC, "desktop", true);
    }

    public void onCommonInit() {
        super.onCommonInit();
        this.defaults();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    @Override
    public TardisDesktopSchema getRandom(Tardis tardis, Random random) {
        return (TardisDesktopSchema)DatapackRegistry.getRandom(this.toList().stream().filter(t -> {
            if (t instanceof DatapackDesktop) {
                DatapackDesktop desktop = (DatapackDesktop)t;
                return desktop != DEFAULT_CAVE;
            }
            return true;
        }).filter(tardis::isUnlocked).toList(), (Random)random, this::fallback);
    }

    public TardisDesktopSchema fallback() {
        throw new UnsupportedOperationException("No desktops registered!");
    }

    public static DesktopRegistry getInstance() {
        return INSTANCE;
    }

    protected void defaults() {
        DEFAULT_CAVE = (TardisDesktopSchema)this.register(new DefaultCaveDesktop());
        DEV = (TardisDesktopSchema)this.register(new DevDesktop());
    }
}

