/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.registry.impl;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.link.LinkableItem;
import dev.amble.ait.client.AITModClient;
import dev.amble.ait.core.AITSounds;
import dev.amble.ait.core.handles.HandlesResponse;
import dev.amble.ait.core.handles.HandlesSound;
import dev.amble.ait.core.item.HandlesItem;
import dev.amble.ait.core.tardis.ServerTardis;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.core.tardis.control.impl.SecurityControl;
import dev.amble.ait.core.tardis.handler.travel.TravelHandlerBase;
import dev.amble.ait.core.world.TardisServerWorld;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_7471;

public class HandlesResponseRegistry {
    public static final class_2370<HandlesResponse> REGISTRY = (class_2370)FabricRegistryBuilder.createSimple((class_5321)class_5321.method_29180((class_2960)AITMod.id("handles"))).buildAndRegister();
    private static HashMap<String, HandlesResponse> COMMANDS_CACHE;
    public static HandlesResponse DEFAULT;

    public static HandlesResponse register(HandlesResponse schema) {
        COMMANDS_CACHE = null;
        return (HandlesResponse)class_2378.method_10230(REGISTRY, (class_2960)schema.id(), (Object)schema);
    }

    public static HandlesResponse get(String command) {
        HandlesResponse found;
        if (COMMANDS_CACHE == null) {
            HandlesResponseRegistry.fillCommands();
        }
        if ((found = COMMANDS_CACHE.get(command)) != null) {
            return found;
        }
        int minDistance = Integer.MAX_VALUE;
        HandlesResponse closest = null;
        for (String key : COMMANDS_CACHE.keySet()) {
            int distanc = COMMANDS_CACHE.get(key).distance(key, command);
            if (distanc >= minDistance) continue;
            minDistance = distanc;
            closest = COMMANDS_CACHE.get(key);
        }
        if (closest != null && minDistance <= AITModClient.CONFIG.handlesLevenshteinDistance) {
            return closest;
        }
        return DEFAULT;
    }

    private static void fillCommands() {
        COMMANDS_CACHE = new HashMap();
        for (HandlesResponse response : REGISTRY) {
            for (String command : response.getCommandWords()) {
                COMMANDS_CACHE.put(command, response);
            }
        }
    }

    public static void init() {
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register(HandlesResponseRegistry::onChatMessage);
        DEFAULT = HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                return this.failure(source);
            }

            @Override
            public class_3414 failureSound() {
                return AITMod.RANDOM.nextBoolean() ? AITSounds.HANDLES_PLEASE_ASK_AGAIN : AITSounds.HANDLES_PARDON;
            }

            @Override
            public List<String> getCommandWords() {
                return List.of();
            }

            public class_2960 id() {
                return AITMod.id("default");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                this.sendChat(player, this.getHelpText());
                return this.success(source);
            }

            private class_2561 getHelpText() {
                return class_2561.method_43470((String)("Available Commands: " + String.join((CharSequence)", ", COMMANDS_CACHE.keySet())));
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("help");
            }

            public class_2960 id() {
                return AITMod.id("help");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){
            private static final List<String> JOKES = List.of("Why did the Dalek apply for a job? It wanted to EX-TER-MINATE its competition!", "How many Time Lords does it take to change a light bulb? None, they just change the timeline.", "Why does the TARDIS always win hide-and-seek? Because it\u2019s in another dimension!", "What do you call a Time Lord with no time? A Lord!", "Why was the TARDIS always calm? Because it\u2019s bigger on the inside.");

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                this.sendChat(player, this.getRandomJoke());
                return this.success(source);
            }

            private class_2561 getRandomJoke() {
                return class_2561.method_43470((String)JOKES.get(AITMod.RANDOM.nextInt(JOKES.size()) - 1));
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("tell me a joke");
            }

            public class_2960 id() {
                return AITMod.id("joke");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){
            private static final List<String> FUN_FACTS = List.of("The first TARDIS was actually painted green!", "Gallifrey has two suns and an orange sky!", "Handles once saved the Doctor\u2019s life by solving a centuries-old riddle.");

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                this.sendChat(player, this.getRandomFunFact());
                return this.success(source);
            }

            private class_2561 getRandomFunFact() {
                return class_2561.method_43470((String)FUN_FACTS.get(AITMod.RANDOM.nextInt(FUN_FACTS.size()) - 1));
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("tell me a fun fact");
            }

            public class_2960 id() {
                return AITMod.id("fun_fact");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                if (tardis.travel().inFlight()) {
                    this.sendChat(player, (class_2561)class_2561.method_43470((String)"The TARDIS is already in flight.."));
                    return this.failure(source);
                }
                tardis.travel().dematerialize();
                this.sendChat(player, (class_2561)class_2561.method_43470((String)"Initiating dematerialization sequence."));
                return this.success(source);
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("dematerialize", "take off");
            }

            public class_2960 id() {
                return AITMod.id("dematerialize");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                if (!tardis.travel().inFlight()) {
                    this.sendChat(player, (class_2561)class_2561.method_43470((String)"The TARDIS is not in flight."));
                    return this.failure(source);
                }
                tardis.travel().rematerialize();
                this.sendChat(player, (class_2561)class_2561.method_43470((String)"Rematerializing."));
                return this.success(source);
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("rematerialize", "land");
            }

            public class_2960 id() {
                return AITMod.id("rematerialize");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                if (tardis.door().locked()) {
                    this.sendChat(player, (class_2561)class_2561.method_43470((String)"Doors already locked"));
                    return this.failure(source);
                }
                tardis.door().setLocked(true);
                this.sendChat(player, (class_2561)class_2561.method_43470((String)"Locking door."));
                return this.success(source);
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("lock", "lock door");
            }

            public class_2960 id() {
                return AITMod.id("lock");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                if (!tardis.door().locked()) {
                    this.sendChat(player, (class_2561)class_2561.method_43470((String)"Doors already unlocked"));
                    return this.failure(source);
                }
                tardis.door().setLocked(false);
                this.sendChat(player, (class_2561)class_2561.method_43470((String)"Unlocking door."));
                return this.success(source);
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("unlock", "unlock door");
            }

            public class_2960 id() {
                return AITMod.id("unlock");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                if (!tardis.waypoint().hasWaypoint()) {
                    this.sendChat(player, (class_2561)class_2561.method_43470((String)"There is no waypoint set."));
                    return this.failure(source);
                }
                this.sendChat(player, (class_2561)class_2561.method_43470((String)"Setting course for waypoint."));
                tardis.waypoint().loadWaypoint();
                return this.success(source);
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("go to waypoint", "travel to waypoint");
            }

            public class_2960 id() {
                return AITMod.id("travel_waypoint");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                if (tardis.door().isOpen()) {
                    this.sendChat(player, (class_2561)class_2561.method_43470((String)"Doors are already open"));
                    return this.failure(source);
                }
                this.sendChat(player, (class_2561)class_2561.method_43470((String)"Opening TARDIS doors."));
                tardis.door().openDoors();
                return this.success(source);
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("open", "open the door");
            }

            public class_2960 id() {
                return AITMod.id("open_door");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                if (!tardis.door().isOpen()) {
                    this.sendChat(player, (class_2561)class_2561.method_43470((String)"Doors are already closed"));
                    return this.failure(source);
                }
                this.sendChat(player, (class_2561)class_2561.method_43470((String)"Closing TARDIS doors."));
                tardis.door().closeDoors();
                return this.success(source);
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("close", "close the door");
            }

            public class_2960 id() {
                return AITMod.id("close_door");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                TravelHandlerBase.State state = tardis.travel().getState();
                this.sendChat(player, (class_2561)class_2561.method_43470((String)("TARDIS State: " + state.name())));
                if (state == TravelHandlerBase.State.FLIGHT) {
                    this.sendChat(player, (class_2561)class_2561.method_43470((String)("Flight is " + tardis.travel().getDurationAsPercentage() + "% complete.")));
                }
                return this.success(source);
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("progress", "flight status", "flight progress");
            }

            public class_2960 id() {
                return AITMod.id("progress");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                this.sendChat(player, (class_2561)class_2561.method_43470((String)"Toggled Shields."));
                tardis.shields().visuallyShielded().toggle();
                return this.success(source);
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("toggle shields", "shields");
            }

            public class_2960 id() {
                return AITMod.id("toggle_shields");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                if (tardis.isRefueling()) {
                    this.sendChat(player, (class_2561)class_2561.method_43470((String)"Refueling is already enabled."));
                    return this.failure(source);
                }
                this.sendChat(player, (class_2561)class_2561.method_43470((String)"Enabling Refueling."));
                tardis.travel().handbrake(true);
                tardis.setRefueling(true);
                return this.success(source);
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("refuel");
            }

            public class_2960 id() {
                return AITMod.id("enable_refuel");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                if (!tardis.isRefueling()) {
                    this.sendChat(player, (class_2561)class_2561.method_43470((String)"Refueling is already disabled."));
                    return this.failure(source);
                }
                this.sendChat(player, (class_2561)class_2561.method_43470((String)"Disabling Refueling."));
                tardis.travel().handbrake(false);
                tardis.setRefueling(false);
                return this.success(source);
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("stop refuel");
            }

            public class_2960 id() {
                return AITMod.id("disable_refuel");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                this.sendChat(player, (class_2561)class_2561.method_43470((String)"Protocol 3 Toggled."));
                tardis.cloak().cloaked().toggle();
                return this.success(source);
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("p3");
            }

            public class_2960 id() {
                return AITMod.id("toggle_cloak");
            }
        });
        HandlesResponseRegistry.register(new HandlesResponse(){

            @Override
            public boolean run(class_3222 player, HandlesSound source, ServerTardis tardis) {
                this.sendChat(player, (class_2561)class_2561.method_43470((String)"Anti-Gravs Toggled."));
                tardis.travel().antigravs().toggle();
                return this.success(source);
            }

            @Override
            public List<String> getCommandWords() {
                return List.of("antigravs");
            }

            public class_2960 id() {
                return AITMod.id("toggle_antigravs");
            }
        });
    }

    private static boolean onChatMessage(class_7471 signedMessage, class_3222 player, class_2556.class_7602 parameters) {
        Object item;
        String message = signedMessage.method_44862();
        boolean bl = message.toLowerCase().startsWith("handles");
        if (player.method_37908().method_8608()) {
            return true;
        }
        if (!bl) {
            return true;
        }
        String command = message.toLowerCase().replace(",", "").replace("handles ", "");
        HandlesResponse response = HandlesResponseRegistry.get(command);
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof HandlesItem) || !((LinkableItem)((Object)(item = (HandlesItem)class_17922))).isLinked(stack)) continue;
            Tardis tardis = ((LinkableItem)((Object)item)).getTardis(player.method_37908(), stack);
            if (tardis.butler().getHandles() != null) break;
            response.run(player, HandlesSound.of(player), tardis.asServer());
            return false;
        }
        if (!((item = player.method_37908()) instanceof TardisServerWorld)) {
            return true;
        }
        TardisServerWorld tardisWorld = (TardisServerWorld)((Object)item);
        ServerTardis tardis = tardisWorld.getTardis();
        if (tardis.butler().getHandles() == null) {
            return true;
        }
        if (response.requiresSudo() && ((Boolean)tardis.stats().security().get()).booleanValue() && !SecurityControl.hasMatchingKey(player, tardis)) {
            return true;
        }
        response.run(player, HandlesSound.of(tardis.asServer()), tardis.asServer());
        return false;
    }
}

