/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.registry.impl;

import dev.amble.ait.AITMod;
import dev.amble.ait.data.datapack.DatapackSonic;
import dev.amble.ait.data.schema.sonic.BuiltinSonic;
import dev.amble.ait.data.schema.sonic.SonicSchema;
import dev.amble.lib.register.unlockable.UnlockableRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.class_2960;

public class SonicRegistry
extends UnlockableRegistry<SonicSchema> {
    private static SonicRegistry INSTANCE;
    public static SonicSchema DEFAULT;

    protected SonicRegistry() {
        super(DatapackSonic::fromInputStream, DatapackSonic.CODEC, "sonic", true);
    }

    public SonicSchema fallback() {
        return DEFAULT;
    }

    protected void defaults() {
        DEFAULT = (SonicSchema)this.register(BuiltinSonic.create("prime"));
        this.register(BuiltinSonic.create("copper"));
        this.register(BuiltinSonic.create("mechanical"));
        this.register(BuiltinSonic.create("fob"));
        this.register(BuiltinSonic.create("coral"));
        this.register(BuiltinSonic.create("renaissance"));
        this.register(BuiltinSonic.create("crystalline"));
        this.register(BuiltinSonic.create("song"));
        this.register(BuiltinSonic.create("singularity"));
        this.register(BuiltinSonic.create("candy_cane"));
        this.register(BuiltinSonic.create("type_100"));
    }

    public static SonicRegistry getInstance() {
        if (INSTANCE == null) {
            AITMod.LOGGER.debug("SonicRegistry was not initialized, creating a new instance");
            INSTANCE = new SonicRegistry();
        }
        return INSTANCE;
    }

    public void populateModels(Consumer<class_2960> consumer) {
        for (SonicSchema schema : this.REGISTRY.values()) {
            SonicSchema.Models models = schema.models();
            models.load(consumer);
            AITMod.LOGGER.debug("Loading sonic '{}' with models: {}", (Object)schema.id(), (Object)models);
        }
    }

    public Collection<class_2960> models() {
        ArrayList<class_2960> result = new ArrayList<class_2960>();
        for (SonicSchema schema : this.REGISTRY.values()) {
            SonicSchema.Models models = schema.models();
            models.load(result::add);
            AITMod.LOGGER.debug("Loading sonic '{}' with models: {}", (Object)schema.id(), (Object)models);
        }
        return result;
    }
}

