/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.registry.impl;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import dev.amble.ait.AITMod;
import dev.amble.ait.api.tardis.TardisComponent;
import dev.amble.ait.core.tardis.TardisDesktop;
import dev.amble.ait.core.tardis.TardisExterior;
import dev.amble.ait.core.tardis.TardisHandlersManager;
import dev.amble.lib.register.Registry;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class TardisComponentRegistry
implements Registry {
    private static final TardisComponentRegistry instance = new TardisComponentRegistry();
    private final Map<String, TardisComponent.IdLike> REGISTRY = new HashMap<String, TardisComponent.IdLike>();
    private TardisComponent.IdLike[] LOOKUP;
    private boolean frozen = false;

    public void register(TardisComponent.IdLike id) {
        if (!id.creatable()) {
            return;
        }
        id.index(this.REGISTRY.size());
        this.REGISTRY.put(id.name(), id);
        if (this.frozen) {
            AITMod.LOGGER.error("Tried to init a component id after the registry got frozen: {}", (Object)id);
        }
    }

    public void register(TardisComponent.IdLike[] idLikes) {
        for (TardisComponent.IdLike idLike : idLikes) {
            this.register(idLike);
        }
    }

    public void onCommonInit() {
        this.register(TardisComponent.Id.ids());
        this.LOOKUP = new TardisComponent.IdLike[this.REGISTRY.size()];
        this.REGISTRY.forEach((name, idLike) -> {
            this.LOOKUP[idLike.index()] = idLike;
        });
        this.frozen = true;
    }

    public void fill(Consumer<TardisComponent> consumer) {
        for (TardisComponent.IdLike id : this.LOOKUP) {
            consumer.accept(id.create());
        }
    }

    public TardisComponent.IdLike get(String name) {
        return switch (name) {
            case "EXTERIOR" -> TardisComponent.Id.EXTERIOR;
            case "DESKTOP" -> TardisComponent.Id.DESKTOP;
            case "HANDLERS" -> TardisComponent.Id.HANDLERS;
            default -> this.REGISTRY.get(name);
        };
    }

    public String get(TardisComponent component) {
        if (component instanceof TardisExterior) {
            return "EXTERIOR";
        }
        if (component instanceof TardisDesktop) {
            return "DESKTOP";
        }
        if (component instanceof TardisHandlersManager) {
            return "HANDLERS";
        }
        return component.getId().name();
    }

    public TardisComponent.IdLike get(int index) {
        return this.LOOKUP[index];
    }

    public static TardisComponent.IdLike[] values() {
        return TardisComponentRegistry.instance.LOOKUP;
    }

    public Collection<TardisComponent.IdLike> getValues() {
        return this.REGISTRY.values();
    }

    public static TardisComponentRegistry getInstance() {
        return instance;
    }

    public static Object idSerializer() {
        return new Serializer();
    }

    private static class Serializer
    implements JsonSerializer<TardisComponent.IdLike>,
    JsonDeserializer<TardisComponent.IdLike> {
        private Serializer() {
        }

        public TardisComponent.IdLike deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return TardisComponentRegistry.getInstance().get(json.getAsString());
        }

        public JsonElement serialize(TardisComponent.IdLike src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.name());
        }
    }
}

