/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.registry.impl.console;

import dev.amble.ait.AITMod;
import dev.amble.ait.data.datapack.DatapackConsole;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.ait.data.schema.console.type.AlnicoType;
import dev.amble.ait.data.schema.console.type.CopperType;
import dev.amble.ait.data.schema.console.type.CoralType;
import dev.amble.ait.data.schema.console.type.CrystallineType;
import dev.amble.ait.data.schema.console.type.HartnellType;
import dev.amble.ait.data.schema.console.type.HudolinType;
import dev.amble.ait.data.schema.console.type.RenaissanceType;
import dev.amble.ait.data.schema.console.type.SteamType;
import dev.amble.ait.data.schema.console.type.ToyotaType;
import dev.amble.lib.register.datapack.DatapackRegistry;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ConsoleRegistry
extends DatapackRegistry<ConsoleTypeSchema> {
    private static final ConsoleRegistry INSTANCE = new ConsoleRegistry();
    public static ConsoleTypeSchema CORAL;
    public static ConsoleTypeSchema HARTNELL;
    public static ConsoleTypeSchema COPPER;
    public static ConsoleTypeSchema TOYOTA;
    public static ConsoleTypeSchema ALNICO;
    public static ConsoleTypeSchema STEAM;
    public static ConsoleTypeSchema HUDOLIN;
    public static ConsoleTypeSchema CRYSTALLINE;
    public static ConsoleTypeSchema RENAISSANCE;
    public static ConsoleTypeSchema HOURGLASS;

    public static ConsoleRegistry getInstance() {
        return INSTANCE;
    }

    public ConsoleTypeSchema fallback() {
        return HARTNELL;
    }

    public void syncToClient(class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        class_2540 secondary = PacketByteBufs.create();
        int counter = 0;
        for (ConsoleTypeSchema schema : this.toList()) {
            if (!(schema instanceof DatapackConsole.SimpleType)) continue;
            DatapackConsole.SimpleType type = (DatapackConsole.SimpleType)schema;
            ++counter;
            secondary.method_49395(DatapackConsole.SimpleType.CODEC, (Object)type);
        }
        buf.writeInt(counter);
        buf.writeBytes((ByteBuf)secondary);
        ServerPlayNetworking.send((class_3222)player, (class_2960)AITMod.id("sync_console_type"), (class_2540)buf);
    }

    public void readFromServer(class_2540 buf) {
        DatapackConsole.SimpleType type;
        for (ConsoleTypeSchema schema : this.toList()) {
            if (!(schema instanceof DatapackConsole.SimpleType)) continue;
            type = (DatapackConsole.SimpleType)schema;
            this.REGISTRY.remove(type.id());
        }
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            type = (DatapackConsole.SimpleType)buf.method_49394(DatapackConsole.SimpleType.CODEC);
            this.register(type);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void onClientInit() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)AITMod.id("sync_console_type"), (client, handler, buf, responseSender) -> this.readFromServer(buf));
    }

    public void onCommonInit() {
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> this.syncToClient(player));
        HARTNELL = (ConsoleTypeSchema)this.register(new HartnellType());
        CORAL = (ConsoleTypeSchema)this.register(new CoralType());
        COPPER = (ConsoleTypeSchema)this.register(new CopperType());
        TOYOTA = (ConsoleTypeSchema)this.register(new ToyotaType());
        ALNICO = (ConsoleTypeSchema)this.register(new AlnicoType());
        STEAM = (ConsoleTypeSchema)this.register(new SteamType());
        HUDOLIN = (ConsoleTypeSchema)this.register(new HudolinType());
        CRYSTALLINE = (ConsoleTypeSchema)this.register(new CrystallineType());
        RENAISSANCE = (ConsoleTypeSchema)this.register(new RenaissanceType());
    }
}

