/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.registry.impl.console.variant;

import dev.amble.ait.AITMod;
import dev.amble.ait.client.models.consoles.BedrockConsoleModel;
import dev.amble.ait.client.models.consoles.ConsoleModel;
import dev.amble.ait.data.datapack.DatapackConsole;
import dev.amble.ait.data.schema.console.ClientConsoleVariantSchema;
import dev.amble.ait.data.schema.console.ConsoleVariantSchema;
import dev.amble.ait.data.schema.console.variant.alnico.client.ClientAlnicoVariant;
import dev.amble.ait.data.schema.console.variant.alnico.client.ClientBlueAlnicoVariant;
import dev.amble.ait.data.schema.console.variant.copper.client.ClientCopperVariant;
import dev.amble.ait.data.schema.console.variant.coral.client.ClientBlueCoralVariant;
import dev.amble.ait.data.schema.console.variant.coral.client.ClientCoralDecayedVariant;
import dev.amble.ait.data.schema.console.variant.coral.client.ClientCoralSithVariant;
import dev.amble.ait.data.schema.console.variant.coral.client.ClientGreenCoralVariant;
import dev.amble.ait.data.schema.console.variant.coral.client.ClientWhiteCoralVariant;
import dev.amble.ait.data.schema.console.variant.crystalline.client.ClientCrystallineVariant;
import dev.amble.ait.data.schema.console.variant.crystalline.client.ClientCrystallineZeitonVariant;
import dev.amble.ait.data.schema.console.variant.hartnell.client.ClientHartnellVariant;
import dev.amble.ait.data.schema.console.variant.hartnell.client.ClientKeltHartnellVariant;
import dev.amble.ait.data.schema.console.variant.hartnell.client.ClientMintHartnellVariant;
import dev.amble.ait.data.schema.console.variant.hartnell.client.ClientWoodenHartnellVariant;
import dev.amble.ait.data.schema.console.variant.hudolin.client.ClientHudolinNatureVariant;
import dev.amble.ait.data.schema.console.variant.hudolin.client.ClientHudolinShortVariant;
import dev.amble.ait.data.schema.console.variant.hudolin.client.ClientHudolinTallVariant;
import dev.amble.ait.data.schema.console.variant.hudolin.client.ClientHudolinVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.client.ClientRenaissanceFireVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.client.ClientRenaissanceIdentityVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.client.ClientRenaissanceIndustriousVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.client.ClientRenaissanceTokamakVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.client.ClientRenaissanceVariant;
import dev.amble.ait.data.schema.console.variant.steam.client.ClientSteamCherryVariant;
import dev.amble.ait.data.schema.console.variant.steam.client.ClientSteamCopperVariant;
import dev.amble.ait.data.schema.console.variant.steam.client.ClientSteamGildedVariant;
import dev.amble.ait.data.schema.console.variant.steam.client.ClientSteamPlaypalVariant;
import dev.amble.ait.data.schema.console.variant.steam.client.ClientSteamSteelVariant;
import dev.amble.ait.data.schema.console.variant.steam.client.ClientSteamVariant;
import dev.amble.ait.data.schema.console.variant.toyota.client.ClientToyotaBlueVariant;
import dev.amble.ait.data.schema.console.variant.toyota.client.ClientToyotaLegacyVariant;
import dev.amble.ait.data.schema.console.variant.toyota.client.ClientToyotaVariant;
import dev.amble.lib.client.bedrock.BedrockModel;
import dev.amble.lib.client.bedrock.BedrockModelRegistry;
import dev.amble.lib.register.datapack.DatapackRegistry;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.joml.Vector3f;

public class ClientConsoleVariantRegistry
extends DatapackRegistry<ClientConsoleVariantSchema> {
    private static ClientConsoleVariantRegistry INSTANCE;
    public static ClientConsoleVariantSchema HARTNELL;
    public static ClientConsoleVariantSchema HARTNELL_WOOD;
    public static ClientConsoleVariantSchema HARTNELL_KELT;
    public static ClientConsoleVariantSchema HARTNELL_MINT;
    public static ClientConsoleVariantSchema CORAL_GREEN;
    public static ClientConsoleVariantSchema CORAL_BLUE;
    public static ClientConsoleVariantSchema CORAL_WHITE;
    public static ClientConsoleVariantSchema CORAL_DECAYED;
    public static ClientConsoleVariantSchema CORAL_SITH;
    public static ClientConsoleVariantSchema TOYOTA;
    public static ClientConsoleVariantSchema TOYOTA_BLUE;
    public static ClientConsoleVariantSchema TOYOTA_LEGACY;
    public static ClientConsoleVariantSchema ALNICO;
    public static ClientConsoleVariantSchema ALNICO_BLUE;
    public static ClientConsoleVariantSchema STEAM;
    public static ClientConsoleVariantSchema STEAM_CHERRY;
    public static ClientConsoleVariantSchema STEAM_STEEL;
    public static ClientConsoleVariantSchema STEAM_GILDED;
    public static ClientConsoleVariantSchema STEAM_PLAYPAL;
    public static ClientConsoleVariantSchema STEAM_COPPER;
    public static ClientConsoleVariantSchema HUDOLIN;
    public static ClientConsoleVariantSchema HUDOLIN_NATURE;
    public static ClientConsoleVariantSchema HUDOLIN_TALL;
    public static ClientConsoleVariantSchema HUDOLIN_SHORT;
    public static ClientConsoleVariantSchema COPPER;
    public static ClientConsoleVariantSchema CRYSTALLINE;
    public static ClientConsoleVariantSchema CRYSTALLINE_ZEITON;
    public static ClientConsoleVariantSchema RENAISSANCE;
    public static ClientConsoleVariantSchema RENAISSANCE_FIRE;
    public static ClientConsoleVariantSchema RENAISSANCE_TOKAMAK;
    public static ClientConsoleVariantSchema RENAISSANCE_IDENTITY;
    public static ClientConsoleVariantSchema RENAISSANCE_INDUSTRIOUS;

    public static DatapackRegistry<ClientConsoleVariantSchema> getInstance() {
        if (INSTANCE == null) {
            AITMod.LOGGER.info("ClientConsoleVariantRegistry was not initialized, Creating a new instance");
            INSTANCE = new ClientConsoleVariantRegistry();
        }
        return INSTANCE;
    }

    public static ClientConsoleVariantSchema withParent(ConsoleVariantSchema parent) {
        for (ClientConsoleVariantSchema schema : ClientConsoleVariantRegistry.getInstance().toList()) {
            if (schema.parent() == null || !schema.parent().id().equals((Object)parent.id())) continue;
            return schema;
        }
        return null;
    }

    public static ClientConsoleVariantSchema withSameParent(ClientConsoleVariantSchema schema) {
        for (ClientConsoleVariantSchema s : ClientConsoleVariantRegistry.getInstance().toList()) {
            if (s.parent() == null || schema.equals(s) || !s.parent().parentId().equals((Object)schema.parent().parentId())) continue;
            return s;
        }
        return null;
    }

    public ClientConsoleVariantSchema fallback() {
        return null;
    }

    public void syncToClient(class_3222 player) {
    }

    public void readFromServer(class_2540 buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.register(ClientConsoleVariantRegistry.convertDatapack((DatapackConsole)buf.method_49394(DatapackConsole.CODEC)));
        }
        AITMod.LOGGER.info("Read {} client console variants from server", (Object)size);
    }

    public static ClientConsoleVariantSchema convertDatapack(final DatapackConsole variant) {
        if (!variant.wasDatapack()) {
            return ClientConsoleVariantRegistry.convertNonDatapack(variant);
        }
        return new ClientConsoleVariantSchema(variant.id()){
            private ClientConsoleVariantSchema sameParent;

            private ClientConsoleVariantSchema getSameParent() {
                if (this.sameParent == null) {
                    this.sameParent = ClientConsoleVariantRegistry.withSameParent(this);
                }
                return this.sameParent;
            }

            @Override
            public class_2960 texture() {
                return variant.texture();
            }

            @Override
            public class_2960 emission() {
                return variant.emission();
            }

            @Override
            public ConsoleModel model() {
                if (variant.model().isPresent()) {
                    return new BedrockConsoleModel((BedrockModel)BedrockModelRegistry.getInstance().get(variant.model().get()));
                }
                return this.getSameParent().model();
            }

            @Override
            public float[] sonicItemRotations() {
                if (variant.sonicRotation().isEmpty()) {
                    if (this.getSameParent() == null) {
                        return new float[]{0.0f, 0.0f};
                    }
                    return this.getSameParent().sonicItemRotations();
                }
                float[] result = new float[2];
                for (int i = 0; i < 2; ++i) {
                    result[i] = variant.sonicRotation().get(i).floatValue();
                }
                return result;
            }

            @Override
            public Vector3f sonicItemTranslations() {
                if (variant.sonicTranslation().equals(0.0f, 0.0f, 0.0f)) {
                    if (this.getSameParent() == null) {
                        return new Vector3f(0.0f, 0.0f, 0.0f);
                    }
                    return this.getSameParent().sonicItemTranslations();
                }
                return variant.sonicTranslation();
            }

            @Override
            public float[] handlesRotations() {
                if (variant.handlesRotation().isEmpty()) {
                    if (this.getSameParent() == null) {
                        return new float[]{0.0f, 0.0f};
                    }
                    return this.getSameParent().handlesRotations();
                }
                float[] result = new float[2];
                for (int i = 0; i < 2; ++i) {
                    result[i] = variant.handlesRotation().get(i).floatValue();
                }
                return result;
            }

            @Override
            public Vector3f handlesTranslations() {
                if (variant.handlesTranslation().equals(0.0f, 0.0f, 0.0f)) {
                    if (this.getSameParent() == null) {
                        return new Vector3f(0.0f, 0.0f, 0.0f);
                    }
                    return this.getSameParent().handlesTranslations();
                }
                return variant.handlesTranslation();
            }
        };
    }

    private static ClientConsoleVariantSchema convertNonDatapack(DatapackConsole variant) {
        if (variant.wasDatapack()) {
            return ClientConsoleVariantRegistry.convertDatapack(variant);
        }
        return (ClientConsoleVariantSchema)ClientConsoleVariantRegistry.getInstance().get(variant.id());
    }

    public void onClientInit() {
        HARTNELL = (ClientConsoleVariantSchema)this.register(new ClientHartnellVariant());
        HARTNELL_KELT = (ClientConsoleVariantSchema)this.register(new ClientKeltHartnellVariant());
        HARTNELL_MINT = (ClientConsoleVariantSchema)this.register(new ClientMintHartnellVariant());
        HARTNELL_WOOD = (ClientConsoleVariantSchema)this.register(new ClientWoodenHartnellVariant());
        CORAL_GREEN = (ClientConsoleVariantSchema)this.register(new ClientGreenCoralVariant());
        CORAL_BLUE = (ClientConsoleVariantSchema)this.register(new ClientBlueCoralVariant());
        CORAL_WHITE = (ClientConsoleVariantSchema)this.register(new ClientWhiteCoralVariant());
        CORAL_DECAYED = (ClientConsoleVariantSchema)this.register(new ClientCoralDecayedVariant());
        CORAL_SITH = (ClientConsoleVariantSchema)this.register(new ClientCoralSithVariant());
        TOYOTA = (ClientConsoleVariantSchema)this.register(new ClientToyotaVariant());
        TOYOTA_BLUE = (ClientConsoleVariantSchema)this.register(new ClientToyotaBlueVariant());
        TOYOTA_LEGACY = (ClientConsoleVariantSchema)this.register(new ClientToyotaLegacyVariant());
        ALNICO = (ClientConsoleVariantSchema)this.register(new ClientAlnicoVariant());
        ALNICO_BLUE = (ClientConsoleVariantSchema)this.register(new ClientBlueAlnicoVariant());
        STEAM = (ClientConsoleVariantSchema)this.register(new ClientSteamVariant());
        STEAM_CHERRY = (ClientConsoleVariantSchema)this.register(new ClientSteamCherryVariant());
        STEAM_STEEL = (ClientConsoleVariantSchema)this.register(new ClientSteamSteelVariant());
        STEAM_GILDED = (ClientConsoleVariantSchema)this.register(new ClientSteamGildedVariant());
        STEAM_COPPER = (ClientConsoleVariantSchema)this.register(new ClientSteamCopperVariant());
        STEAM_PLAYPAL = (ClientConsoleVariantSchema)this.register(new ClientSteamPlaypalVariant());
        HUDOLIN = (ClientConsoleVariantSchema)this.register(new ClientHudolinVariant());
        HUDOLIN_NATURE = (ClientConsoleVariantSchema)this.register(new ClientHudolinNatureVariant());
        HUDOLIN_TALL = (ClientConsoleVariantSchema)this.register(new ClientHudolinTallVariant());
        HUDOLIN_SHORT = (ClientConsoleVariantSchema)this.register(new ClientHudolinShortVariant());
        COPPER = (ClientConsoleVariantSchema)this.register(new ClientCopperVariant());
        CRYSTALLINE = (ClientConsoleVariantSchema)this.register(new ClientCrystallineVariant());
        CRYSTALLINE_ZEITON = (ClientConsoleVariantSchema)this.register(new ClientCrystallineZeitonVariant());
        RENAISSANCE = (ClientConsoleVariantSchema)this.register(new ClientRenaissanceVariant());
        RENAISSANCE_TOKAMAK = (ClientConsoleVariantSchema)this.register(new ClientRenaissanceTokamakVariant());
        RENAISSANCE_FIRE = (ClientConsoleVariantSchema)this.register(new ClientRenaissanceFireVariant());
        RENAISSANCE_IDENTITY = (ClientConsoleVariantSchema)this.register(new ClientRenaissanceIdentityVariant());
        RENAISSANCE_INDUSTRIOUS = (ClientConsoleVariantSchema)this.register(new ClientRenaissanceIndustriousVariant());
    }
}

