/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.registry.impl.console.variant;

import dev.amble.ait.AITMod;
import dev.amble.ait.data.datapack.DatapackConsole;
import dev.amble.ait.data.datapack.DatapackExterior;
import dev.amble.ait.data.schema.console.ConsoleTypeSchema;
import dev.amble.ait.data.schema.console.ConsoleVariantSchema;
import dev.amble.ait.data.schema.console.variant.alnico.AlnicoVariant;
import dev.amble.ait.data.schema.console.variant.alnico.BlueAlnicoVariant;
import dev.amble.ait.data.schema.console.variant.copper.CopperVariant;
import dev.amble.ait.data.schema.console.variant.coral.BlueCoralVariant;
import dev.amble.ait.data.schema.console.variant.coral.CoralDecayedVariant;
import dev.amble.ait.data.schema.console.variant.coral.CoralSithVariant;
import dev.amble.ait.data.schema.console.variant.coral.CoralVariant;
import dev.amble.ait.data.schema.console.variant.coral.WhiteCoralVariant;
import dev.amble.ait.data.schema.console.variant.crystalline.CrystallineVariant;
import dev.amble.ait.data.schema.console.variant.crystalline.CrystallineZeitonVariant;
import dev.amble.ait.data.schema.console.variant.hartnell.HartnellVariant;
import dev.amble.ait.data.schema.console.variant.hartnell.KeltHartnellVariant;
import dev.amble.ait.data.schema.console.variant.hartnell.MintHartnellVariant;
import dev.amble.ait.data.schema.console.variant.hartnell.WoodenHartnellVariant;
import dev.amble.ait.data.schema.console.variant.hudolin.HudolinNatureVariant;
import dev.amble.ait.data.schema.console.variant.hudolin.HudolinShortVariant;
import dev.amble.ait.data.schema.console.variant.hudolin.HudolinTallVariant;
import dev.amble.ait.data.schema.console.variant.hudolin.HudolinVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.RenaissanceFireVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.RenaissanceIdentityVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.RenaissanceIndustriousVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.RenaissanceTokamakVariant;
import dev.amble.ait.data.schema.console.variant.renaissance.RenaissanceVariant;
import dev.amble.ait.data.schema.console.variant.steam.SteamCherryVariant;
import dev.amble.ait.data.schema.console.variant.steam.SteamCopperVariant;
import dev.amble.ait.data.schema.console.variant.steam.SteamGildedVariant;
import dev.amble.ait.data.schema.console.variant.steam.SteamPlaypalVariant;
import dev.amble.ait.data.schema.console.variant.steam.SteamSteelVariant;
import dev.amble.ait.data.schema.console.variant.steam.SteamVariant;
import dev.amble.ait.data.schema.console.variant.toyota.ToyotaBlueVariant;
import dev.amble.ait.data.schema.console.variant.toyota.ToyotaLegacyVariant;
import dev.amble.ait.data.schema.console.variant.toyota.ToyotaVariant;
import dev.amble.ait.registry.impl.console.variant.ClientConsoleVariantRegistry;
import dev.amble.lib.register.unlockable.UnlockableRegistry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import org.joml.Vector3f;

public class ConsoleVariantRegistry
extends UnlockableRegistry<ConsoleVariantSchema> {
    private static ConsoleVariantRegistry INSTANCE;
    public static ConsoleVariantSchema HARTNELL;
    public static ConsoleVariantSchema HARTNELL_WOOD;
    public static ConsoleVariantSchema HARTNELL_KELT;
    public static ConsoleVariantSchema HARTNELL_MINT;
    public static ConsoleVariantSchema CORAL;
    public static ConsoleVariantSchema CORAL_BLUE;
    public static ConsoleVariantSchema CORAL_WHITE;
    public static ConsoleVariantSchema CORAL_SITH;
    public static ConsoleVariantSchema CORAL_DECAYED;
    public static ConsoleVariantSchema TOYOTA;
    public static ConsoleVariantSchema TOYOTA_BLUE;
    public static ConsoleVariantSchema TOYOTA_LEGACY;
    public static ConsoleVariantSchema ALNICO;
    public static ConsoleVariantSchema ALNICO_BLUE;
    public static ConsoleVariantSchema STEAM;
    public static ConsoleVariantSchema STEAM_CHERRY;
    public static ConsoleVariantSchema STEAM_STEEL;
    public static ConsoleVariantSchema STEAM_GILDED;
    public static ConsoleVariantSchema STEAM_COPPER;
    public static ConsoleVariantSchema STEAM_PLAYPAL;
    public static ConsoleVariantSchema HUDOLIN;
    public static ConsoleVariantSchema HUDOLIN_NATURE;
    public static ConsoleVariantSchema HUDOLIN_TALL;
    public static ConsoleVariantSchema HUDOLIN_SHORT;
    public static ConsoleVariantSchema COPPER;
    public static ConsoleVariantSchema BOREALIS;
    public static ConsoleVariantSchema CRYSTALLINE;
    public static ConsoleVariantSchema CRYSTALLINE_ZEITON;
    public static ConsoleVariantSchema RENAISSANCE;
    public static ConsoleVariantSchema RENAISSANCE_TOKAMAK;
    public static ConsoleVariantSchema RENAISSANCE_FIRE;
    public static ConsoleVariantSchema RENAISSANCE_IDENTITY;
    public static ConsoleVariantSchema RENAISSANCE_INDUSTRIOUS;

    protected ConsoleVariantRegistry() {
        super(DatapackConsole::fromInputStream, null, "console_variants", "console", true, "ait");
    }

    public static ConsoleVariantSchema registerStatic(ConsoleVariantSchema schema) {
        return (ConsoleVariantSchema)ConsoleVariantRegistry.getInstance().register(schema);
    }

    public ConsoleVariantSchema fallback() {
        return null;
    }

    public void syncToClient(class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(this.REGISTRY.size());
        for (ConsoleVariantSchema schema : this.REGISTRY.values()) {
            if (schema instanceof DatapackConsole) {
                DatapackConsole variant = (DatapackConsole)schema;
                buf.method_49395(DatapackConsole.CODEC, (Object)variant);
                continue;
            }
            buf.method_49395(DatapackConsole.CODEC, (Object)new DatapackConsole(schema.id(), Optional.of(schema.parent().id()), DatapackExterior.DEFAULT_TEXTURE, DatapackExterior.DEFAULT_TEXTURE, List.of(), new Vector3f(), List.of(), new Vector3f(), Optional.empty(), class_243.field_1353, class_243.field_1353, null, Optional.empty(), false));
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.packet, (class_2540)buf);
    }

    public void onCommonInit() {
        super.onCommonInit();
        this.defaults();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    public void readFromServer(class_2540 buf) {
        class_2540 copy = PacketByteBufs.copy((ByteBuf)buf);
        ClientConsoleVariantRegistry.getInstance().readFromServer(copy);
        this.REGISTRY.clear();
        this.defaults();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            DatapackConsole variant = (DatapackConsole)buf.method_49394(DatapackConsole.CODEC);
            if (!variant.wasDatapack()) continue;
            this.register(variant);
        }
        AITMod.LOGGER.info("Read {} console variants from server", (Object)size);
    }

    public static ConsoleVariantRegistry getInstance() {
        if (INSTANCE == null) {
            AITMod.LOGGER.debug("ConsoleVariantRegistry was not initialized, Creating a new instance");
            INSTANCE = new ConsoleVariantRegistry();
        }
        return INSTANCE;
    }

    public static List<ConsoleVariantSchema> withParent(ConsoleTypeSchema parent) {
        ArrayList<ConsoleVariantSchema> list = new ArrayList<ConsoleVariantSchema>();
        for (ConsoleVariantSchema schema : ConsoleVariantRegistry.getInstance().REGISTRY.values()) {
            if (schema.parent() == null) {
                AITMod.LOGGER.warn("Console variant {} has no parent, skipping", (Object)schema.id());
                continue;
            }
            if (!schema.parent().equals(parent)) continue;
            list.add(schema);
        }
        return list;
    }

    protected void defaults() {
        HARTNELL = ConsoleVariantRegistry.registerStatic(new HartnellVariant());
        HARTNELL_KELT = ConsoleVariantRegistry.registerStatic(new KeltHartnellVariant());
        HARTNELL_MINT = ConsoleVariantRegistry.registerStatic(new MintHartnellVariant());
        HARTNELL_WOOD = ConsoleVariantRegistry.registerStatic(new WoodenHartnellVariant());
        CORAL = ConsoleVariantRegistry.registerStatic(new CoralVariant());
        CORAL_BLUE = ConsoleVariantRegistry.registerStatic(new BlueCoralVariant());
        CORAL_WHITE = ConsoleVariantRegistry.registerStatic(new WhiteCoralVariant());
        CORAL_SITH = ConsoleVariantRegistry.registerStatic(new CoralSithVariant());
        CORAL_DECAYED = ConsoleVariantRegistry.registerStatic(new CoralDecayedVariant());
        TOYOTA = ConsoleVariantRegistry.registerStatic(new ToyotaVariant());
        TOYOTA_BLUE = ConsoleVariantRegistry.registerStatic(new ToyotaBlueVariant());
        TOYOTA_LEGACY = ConsoleVariantRegistry.registerStatic(new ToyotaLegacyVariant());
        ALNICO = ConsoleVariantRegistry.registerStatic(new AlnicoVariant());
        ALNICO_BLUE = ConsoleVariantRegistry.registerStatic(new BlueAlnicoVariant());
        STEAM = ConsoleVariantRegistry.registerStatic(new SteamVariant());
        STEAM_CHERRY = ConsoleVariantRegistry.registerStatic(new SteamCherryVariant());
        STEAM_STEEL = ConsoleVariantRegistry.registerStatic(new SteamSteelVariant());
        STEAM_GILDED = ConsoleVariantRegistry.registerStatic(new SteamGildedVariant());
        STEAM_PLAYPAL = ConsoleVariantRegistry.registerStatic(new SteamPlaypalVariant());
        STEAM_COPPER = ConsoleVariantRegistry.registerStatic(new SteamCopperVariant());
        HUDOLIN = ConsoleVariantRegistry.registerStatic(new HudolinVariant());
        HUDOLIN_NATURE = ConsoleVariantRegistry.registerStatic(new HudolinNatureVariant());
        HUDOLIN_TALL = ConsoleVariantRegistry.registerStatic(new HudolinTallVariant());
        HUDOLIN_SHORT = ConsoleVariantRegistry.registerStatic(new HudolinShortVariant());
        COPPER = ConsoleVariantRegistry.registerStatic(new CopperVariant());
        CRYSTALLINE = ConsoleVariantRegistry.registerStatic(new CrystallineVariant());
        CRYSTALLINE_ZEITON = ConsoleVariantRegistry.registerStatic(new CrystallineZeitonVariant());
        RENAISSANCE = ConsoleVariantRegistry.registerStatic(new RenaissanceVariant());
        RENAISSANCE_TOKAMAK = ConsoleVariantRegistry.registerStatic(new RenaissanceTokamakVariant());
        RENAISSANCE_FIRE = ConsoleVariantRegistry.registerStatic(new RenaissanceFireVariant());
        RENAISSANCE_IDENTITY = ConsoleVariantRegistry.registerStatic(new RenaissanceIdentityVariant());
        RENAISSANCE_INDUSTRIOUS = ConsoleVariantRegistry.registerStatic(new RenaissanceIndustriousVariant());
    }
}

