/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.registry.impl.door;

import dev.amble.ait.client.models.AnimatedModel;
import dev.amble.ait.client.tardis.ClientTardis;
import dev.amble.ait.core.blockentities.DoorBlockEntity;
import dev.amble.ait.data.schema.door.AnimatedDoor;
import dev.amble.ait.data.schema.door.ClientDoorSchema;
import dev.amble.ait.data.schema.door.DatapackDoor;
import dev.amble.ait.data.schema.door.DoorSchema;
import dev.amble.ait.data.schema.door.impl.ClientAdaptiveDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientBookshelfDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientBoothDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientCapsuleDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientClassicDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientClassicHudolinDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientDalekModDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientEasterHeadDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientGeometricDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientGrowthDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientPipeDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientPlinthDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientPoliceBoxCoralDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientPoliceBoxDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientPoliceBoxRenaissanceDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientPresentDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientRenegadeDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientStallionDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClientTardimDoorVariant;
import dev.amble.ait.data.schema.door.impl.exclusive.ClientBlueBoxDoorVariant;
import dev.amble.ait.data.schema.door.impl.exclusive.ClientDoomDoorVariant;
import dev.amble.ait.registry.impl.door.DoorRegistry;
import dev.amble.lib.client.bedrock.BedrockModel;
import dev.amble.lib.client.bedrock.BedrockModelRegistry;
import dev.amble.lib.register.datapack.DatapackRegistry;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

public class ClientDoorRegistry
extends DatapackRegistry<ClientDoorSchema> {
    private static final ClientDoorRegistry INSTANCE = new ClientDoorRegistry();
    public static ClientDoorSchema TARDIM;
    public static ClientDoorSchema CLASSIC;
    public static ClientDoorSchema CLASSIC_HUDOLIN;
    public static ClientDoorSchema BOOTH;
    public static ClientDoorSchema CAPSULE;
    public static ClientDoorSchema BOX;
    public static ClientDoorSchema BOX_CORAL;
    public static ClientDoorSchema BOX_RENAISSANCE;
    public static ClientDoorSchema HEAD;
    public static ClientDoorSchema GROWTH;
    public static ClientDoorSchema PLINTH;
    public static ClientDoorSchema RENEGADE;
    public static ClientDoorSchema BOOKSHELF;
    public static ClientDoorSchema GEOMETRIC;
    public static ClientDoorSchema STALLION;
    public static ClientDoorSchema ADAPTIVE;
    public static ClientDoorSchema DALEK_MOD;
    public static ClientDoorSchema PRESENT;
    public static ClientDoorSchema PIPE;
    public static ClientDoorSchema DOOM;
    public static ClientDoorSchema BLUE_BOX;

    public static ClientDoorRegistry getInstance() {
        return INSTANCE;
    }

    public static ClientDoorSchema withParent(DoorSchema parent) {
        for (ClientDoorSchema schema : ClientDoorRegistry.getInstance().toList()) {
            if (schema.parent() == null || !schema.parent().id().equals((Object)parent.id())) continue;
            return schema;
        }
        return null;
    }

    public void onClientInit() {
        TARDIM = (ClientDoorSchema)this.register(new ClientTardimDoorVariant());
        CLASSIC = (ClientDoorSchema)this.register(new ClientClassicDoorVariant());
        CLASSIC_HUDOLIN = (ClientDoorSchema)this.register(new ClientClassicHudolinDoorVariant());
        BOOTH = (ClientDoorSchema)this.register(new ClientBoothDoorVariant());
        CAPSULE = (ClientDoorSchema)this.register(new ClientCapsuleDoorVariant());
        BOX = (ClientDoorSchema)this.register(new ClientPoliceBoxDoorVariant());
        BOX_CORAL = (ClientDoorSchema)this.register(new ClientPoliceBoxCoralDoorVariant());
        BOX_RENAISSANCE = (ClientDoorSchema)this.register(new ClientPoliceBoxRenaissanceDoorVariant());
        HEAD = (ClientDoorSchema)this.register(new ClientEasterHeadDoorVariant());
        GROWTH = (ClientDoorSchema)this.register(new ClientGrowthDoorVariant());
        PLINTH = (ClientDoorSchema)this.register(new ClientPlinthDoorVariant());
        RENEGADE = (ClientDoorSchema)this.register(new ClientRenegadeDoorVariant());
        BOOKSHELF = (ClientDoorSchema)this.register(new ClientBookshelfDoorVariant());
        GEOMETRIC = (ClientDoorSchema)this.register(new ClientGeometricDoorVariant());
        STALLION = (ClientDoorSchema)this.register(new ClientStallionDoorVariant());
        ADAPTIVE = (ClientDoorSchema)this.register(new ClientAdaptiveDoorVariant());
        DALEK_MOD = (ClientDoorSchema)this.register(new ClientDalekModDoorVariant());
        PRESENT = (ClientDoorSchema)this.register(new ClientPresentDoorVariant());
        PIPE = (ClientDoorSchema)this.register(new ClientPipeDoorVariant());
        DOOM = (ClientDoorSchema)this.register(new ClientDoomDoorVariant());
        BLUE_BOX = (ClientDoorSchema)this.register(new ClientBlueBoxDoorVariant());
    }

    public ClientDoorSchema fallback() {
        return CAPSULE;
    }

    public void syncToClient(class_3222 player) {
    }

    public void readFromServer(class_2540 buf) {
        for (DoorSchema schema : DoorRegistry.getInstance().toList()) {
            DatapackDoor variant;
            ClientDoorSchema clientSchema;
            if (!(schema instanceof DatapackDoor) || (clientSchema = ClientDoorRegistry.convertDatapack(variant = (DatapackDoor)schema)) == null) continue;
            this.register(clientSchema);
        }
    }

    public static ClientDoorSchema convertDatapack(final DatapackDoor variant) {
        if (!variant.wasDatapack()) {
            return ClientDoorRegistry.convertNonDatapack(variant);
        }
        return new ClientDoorSchema(variant.id()){

            @Override
            public AnimatedModel<DoorBlockEntity> model() {
                BedrockModel model = (BedrockModel)BedrockModelRegistry.getInstance().get(variant.getModelId());
                final class_630 root = model.create().method_32109();
                return new AnimatedModel<DoorBlockEntity>(){

                    @Override
                    public void renderWithAnimations(ClientTardis tardis, DoorBlockEntity be, class_630 root2, class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float pAlpha, float tickDelta) {
                        matrices.method_22903();
                        DoorSchema schema = tardis.getExterior().getVariant().door();
                        if (schema instanceof AnimatedDoor) {
                            AnimatedDoor animDoor = (AnimatedDoor)((Object)schema);
                            this.method_32008().method_32088().forEach(class_630::method_41923);
                            animDoor.runAnimations(root2, matrices, tickDelta, tardis);
                        }
                        root2.method_22699(matrices, vertices, light, overlay, red, green, blue, pAlpha);
                        matrices.method_22909();
                    }

                    @Override
                    public class_630 method_32008() {
                        return root;
                    }
                };
            }
        };
    }

    private static ClientDoorSchema convertNonDatapack(DatapackDoor variant) {
        if (variant.wasDatapack()) {
            return ClientDoorRegistry.convertDatapack(variant);
        }
        return (ClientDoorSchema)ClientDoorRegistry.getInstance().get(variant.id());
    }
}

