/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.registry.impl.door;

import dev.amble.ait.data.schema.door.DatapackDoor;
import dev.amble.ait.data.schema.door.DoorSchema;
import dev.amble.ait.data.schema.door.impl.AdaptiveDoorVariant;
import dev.amble.ait.data.schema.door.impl.BookshelfDoorVariant;
import dev.amble.ait.data.schema.door.impl.BoothDoorVariant;
import dev.amble.ait.data.schema.door.impl.CapsuleDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClassicDoorVariant;
import dev.amble.ait.data.schema.door.impl.ClassicHudolinDoorVariant;
import dev.amble.ait.data.schema.door.impl.CoralGrowthDoorVariant;
import dev.amble.ait.data.schema.door.impl.DalekModDoorVariant;
import dev.amble.ait.data.schema.door.impl.EasterHeadDoorVariant;
import dev.amble.ait.data.schema.door.impl.GeometricDoorVariant;
import dev.amble.ait.data.schema.door.impl.PipeDoorVariant;
import dev.amble.ait.data.schema.door.impl.PlinthDoorVariant;
import dev.amble.ait.data.schema.door.impl.PoliceBoxCoralDoorVariant;
import dev.amble.ait.data.schema.door.impl.PoliceBoxDoorVariant;
import dev.amble.ait.data.schema.door.impl.PoliceBoxRenaissanceDoorVariant;
import dev.amble.ait.data.schema.door.impl.PresentDoorVariant;
import dev.amble.ait.data.schema.door.impl.RenegadeDoorVariant;
import dev.amble.ait.data.schema.door.impl.StallionDoorVariant;
import dev.amble.ait.data.schema.door.impl.TardimDoorVariant;
import dev.amble.ait.data.schema.door.impl.exclusive.BlueBoxDoorVariant;
import dev.amble.ait.data.schema.door.impl.exclusive.DoomDoorVariant;
import dev.amble.ait.registry.impl.door.ClientDoorRegistry;
import dev.amble.lib.register.datapack.SimpleDatapackRegistry;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class DoorRegistry
extends SimpleDatapackRegistry<DoorSchema> {
    private static DoorRegistry INSTANCE;
    public static DoorSchema TARDIM;
    public static DoorSchema CLASSIC;
    public static DoorSchema CLASSIC_HUDOLIN;
    public static DoorSchema BOOTH;
    public static DoorSchema CAPSULE;
    public static DoorSchema BOX;
    public static DoorSchema BOX_CORAL;
    public static DoorSchema BOX_RENAISSANCE;
    public static DoorSchema HEAD;
    public static DoorSchema GROWTH;
    public static DoorSchema PLINTH;
    public static DoorSchema RENEGADE;
    public static DoorSchema BOOKSHELF;
    public static DoorSchema GEOMETRIC;
    public static DoorSchema STALLION;
    public static DoorSchema ADAPTIVE;
    public static DoorSchema DALEK_MOD;
    public static DoorSchema PRESENT;
    public static DoorSchema PIPE;
    public static DoorSchema DOOM;
    public static DoorSchema BLUE_BOX;

    private DoorRegistry() {
        super(DatapackDoor::fromInputStream, null, "door", true, "ait");
    }

    public static DoorRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DoorRegistry();
        }
        return INSTANCE;
    }

    public void onCommonInit() {
        super.onCommonInit();
        this.defaults();
    }

    public DoorSchema fallback() {
        return CAPSULE;
    }

    public void syncToClient(class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        class_2540 secondary = PacketByteBufs.create();
        int counter = 0;
        for (DoorSchema schema : this.toList()) {
            if (!(schema instanceof DatapackDoor)) continue;
            DatapackDoor type = (DatapackDoor)schema;
            ++counter;
            secondary.method_49395(DatapackDoor.CODEC, (Object)type);
        }
        buf.writeInt(counter);
        buf.writeBytes((ByteBuf)secondary);
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.packet, (class_2540)buf);
    }

    public void readFromServer(class_2540 buf) {
        DatapackDoor type;
        class_2540 copy = PacketByteBufs.copy((ByteBuf)buf);
        for (DoorSchema schema : this.toList()) {
            if (!(schema instanceof DatapackDoor)) continue;
            type = (DatapackDoor)schema;
            this.REGISTRY.remove(type.id());
        }
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            type = (DatapackDoor)buf.method_49394(DatapackDoor.CODEC);
            this.register(type);
        }
        ClientDoorRegistry.getInstance().readFromServer(copy);
    }

    protected void defaults() {
        TARDIM = (DoorSchema)this.register(new TardimDoorVariant());
        CLASSIC = (DoorSchema)this.register(new ClassicDoorVariant());
        CLASSIC_HUDOLIN = (DoorSchema)this.register(new ClassicHudolinDoorVariant());
        BOOTH = (DoorSchema)this.register(new BoothDoorVariant());
        CAPSULE = (DoorSchema)this.register(new CapsuleDoorVariant());
        BOX = (DoorSchema)this.register(new PoliceBoxDoorVariant());
        BOX_CORAL = (DoorSchema)this.register(new PoliceBoxCoralDoorVariant());
        BOX_RENAISSANCE = (DoorSchema)this.register(new PoliceBoxRenaissanceDoorVariant());
        HEAD = (DoorSchema)this.register(new EasterHeadDoorVariant());
        GROWTH = (DoorSchema)this.register(new CoralGrowthDoorVariant());
        PLINTH = (DoorSchema)this.register(new PlinthDoorVariant());
        RENEGADE = (DoorSchema)this.register(new RenegadeDoorVariant());
        BOOKSHELF = (DoorSchema)this.register(new BookshelfDoorVariant());
        GEOMETRIC = (DoorSchema)this.register(new GeometricDoorVariant());
        STALLION = (DoorSchema)this.register(new StallionDoorVariant());
        ADAPTIVE = (DoorSchema)this.register(new AdaptiveDoorVariant());
        DALEK_MOD = (DoorSchema)this.register(new DalekModDoorVariant());
        PRESENT = (DoorSchema)this.register(new PresentDoorVariant());
        PIPE = (DoorSchema)this.register(new PipeDoorVariant());
        DOOM = (DoorSchema)this.register(new DoomDoorVariant());
        BLUE_BOX = (DoorSchema)this.register(new BlueBoxDoorVariant());
    }
}

