/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.ait.registry.impl.exterior;

import dev.amble.ait.AITMod;
import dev.amble.ait.api.AITRegistryEvents;
import dev.amble.ait.data.datapack.DatapackExterior;
import dev.amble.ait.data.schema.exterior.ExteriorCategorySchema;
import dev.amble.ait.data.schema.exterior.ExteriorVariantSchema;
import dev.amble.ait.data.schema.exterior.variant.adaptive.AdaptiveVariant;
import dev.amble.ait.data.schema.exterior.variant.bookshelf.BookshelfDefaultVariant;
import dev.amble.ait.data.schema.exterior.variant.booth.BoothBlueVariant;
import dev.amble.ait.data.schema.exterior.variant.booth.BoothDefaultVariant;
import dev.amble.ait.data.schema.exterior.variant.booth.BoothFireVariant;
import dev.amble.ait.data.schema.exterior.variant.booth.BoothGildedVariant;
import dev.amble.ait.data.schema.exterior.variant.booth.BoothSoulVariant;
import dev.amble.ait.data.schema.exterior.variant.booth.BoothVintageVariant;
import dev.amble.ait.data.schema.exterior.variant.box.PoliceBoxCherryVariant;
import dev.amble.ait.data.schema.exterior.variant.box.PoliceBoxCoralVariant;
import dev.amble.ait.data.schema.exterior.variant.box.PoliceBoxDefaultVariant;
import dev.amble.ait.data.schema.exterior.variant.box.PoliceBoxFireVariant;
import dev.amble.ait.data.schema.exterior.variant.box.PoliceBoxFuturisticVariant;
import dev.amble.ait.data.schema.exterior.variant.box.PoliceBoxRenaissanceVariant;
import dev.amble.ait.data.schema.exterior.variant.box.PoliceBoxSoulVariant;
import dev.amble.ait.data.schema.exterior.variant.capsule.CapsuleDefaultVariant;
import dev.amble.ait.data.schema.exterior.variant.capsule.CapsuleFireVariant;
import dev.amble.ait.data.schema.exterior.variant.capsule.CapsuleSoulVariant;
import dev.amble.ait.data.schema.exterior.variant.classic.ClassicBoxDefinitiveVariant;
import dev.amble.ait.data.schema.exterior.variant.classic.ClassicBoxExileVariant;
import dev.amble.ait.data.schema.exterior.variant.classic.ClassicBoxHudolinVariant;
import dev.amble.ait.data.schema.exterior.variant.classic.ClassicBoxMintVariant;
import dev.amble.ait.data.schema.exterior.variant.classic.ClassicBoxPrimeVariant;
import dev.amble.ait.data.schema.exterior.variant.classic.ClassicBoxPtoredVariant;
import dev.amble.ait.data.schema.exterior.variant.classic.ClassicBoxShalkaVariant;
import dev.amble.ait.data.schema.exterior.variant.classic.ClassicBoxYetiVariant;
import dev.amble.ait.data.schema.exterior.variant.dalek_mod.DalekMod1963Variant;
import dev.amble.ait.data.schema.exterior.variant.dalek_mod.DalekMod1967Variant;
import dev.amble.ait.data.schema.exterior.variant.dalek_mod.DalekMod1970Variant;
import dev.amble.ait.data.schema.exterior.variant.dalek_mod.DalekMod1976Variant;
import dev.amble.ait.data.schema.exterior.variant.dalek_mod.DalekMod1980Variant;
import dev.amble.ait.data.schema.exterior.variant.easter_head.EasterHeadDefaultVariant;
import dev.amble.ait.data.schema.exterior.variant.easter_head.EasterHeadFireVariant;
import dev.amble.ait.data.schema.exterior.variant.easter_head.EasterHeadSoulVariant;
import dev.amble.ait.data.schema.exterior.variant.exclusive.doom.DoomVariant;
import dev.amble.ait.data.schema.exterior.variant.exclusive.wanderer.BoothWandererVariant;
import dev.amble.ait.data.schema.exterior.variant.geometric.GeometricDefaultVariant;
import dev.amble.ait.data.schema.exterior.variant.geometric.GeometricFireVariant;
import dev.amble.ait.data.schema.exterior.variant.geometric.GeometricGildedVariant;
import dev.amble.ait.data.schema.exterior.variant.geometric.GeometricSoulVariant;
import dev.amble.ait.data.schema.exterior.variant.growth.CoralGrowthVariant;
import dev.amble.ait.data.schema.exterior.variant.pipe.PipeBlueVariant;
import dev.amble.ait.data.schema.exterior.variant.pipe.PipeDefaultVariant;
import dev.amble.ait.data.schema.exterior.variant.pipe.PipeRedVariant;
import dev.amble.ait.data.schema.exterior.variant.plinth.PlinthDefaultVariant;
import dev.amble.ait.data.schema.exterior.variant.plinth.PlinthFireVariant;
import dev.amble.ait.data.schema.exterior.variant.plinth.PlinthSoulVariant;
import dev.amble.ait.data.schema.exterior.variant.renegade.RenegadeCabinetVariant;
import dev.amble.ait.data.schema.exterior.variant.renegade.RenegadeDefaultVariant;
import dev.amble.ait.data.schema.exterior.variant.renegade.RenegadeTronVariant;
import dev.amble.ait.data.schema.exterior.variant.stallion.StallionDefaultVariant;
import dev.amble.ait.data.schema.exterior.variant.stallion.StallionFireVariant;
import dev.amble.ait.data.schema.exterior.variant.stallion.StallionSoulVariant;
import dev.amble.ait.data.schema.exterior.variant.stallion.StallionSteelVariant;
import dev.amble.ait.data.schema.exterior.variant.tardim.TardimDefaultVariant;
import dev.amble.ait.data.schema.exterior.variant.tardim.TardimFireVariant;
import dev.amble.ait.data.schema.exterior.variant.tardim.TardimSoulVariant;
import dev.amble.ait.registry.impl.exterior.ClientExteriorVariantRegistry;
import dev.amble.lib.register.datapack.DatapackRegistry;
import dev.amble.lib.register.unlockable.UnlockableRegistry;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;

public class ExteriorVariantRegistry
extends UnlockableRegistry<ExteriorVariantSchema> {
    private static ExteriorVariantRegistry INSTANCE;
    public static ExteriorVariantSchema TARDIM_DEFAULT;
    public static ExteriorVariantSchema TARDIM_FIRE;
    public static ExteriorVariantSchema TARDIM_SOUL;
    public static ExteriorVariantSchema BOX_DEFAULT;
    public static ExteriorVariantSchema BOX_FIRE;
    public static ExteriorVariantSchema BOX_SOUL;
    public static ExteriorVariantSchema BOX_FUTURE;
    public static ExteriorVariantSchema BOX_CORAL;
    public static ExteriorVariantSchema BOX_RENAISSANCE;
    public static ExteriorVariantSchema BOX_CHERRY;
    public static ExteriorVariantSchema PRIME;
    public static ExteriorVariantSchema YETI;
    public static ExteriorVariantSchema DEFINITIVE;
    public static ExteriorVariantSchema PTORED;
    public static ExteriorVariantSchema MINT;
    public static ExteriorVariantSchema HUDOLIN;
    public static ExteriorVariantSchema SHALKA;
    public static ExteriorVariantSchema EXILE;
    public static ExteriorVariantSchema CAPSULE_DEFAULT;
    public static ExteriorVariantSchema CAPSULE_SOUL;
    public static ExteriorVariantSchema CAPSULE_FIRE;
    public static ExteriorVariantSchema BOOTH_DEFAULT;
    public static ExteriorVariantSchema BOOTH_FIRE;
    public static ExteriorVariantSchema BOOTH_SOUL;
    public static ExteriorVariantSchema BOOTH_VINTAGE;
    public static ExteriorVariantSchema BOOTH_BLUE;
    public static ExteriorVariantSchema BOOTH_GILDED;
    public static ExteriorVariantSchema HEAD_DEFAULT;
    public static ExteriorVariantSchema HEAD_SOUL;
    public static ExteriorVariantSchema HEAD_FIRE;
    public static ExteriorVariantSchema CORAL_GROWTH;
    public static ExteriorVariantSchema PLINTH_DEFAULT;
    public static ExteriorVariantSchema PLINTH_SOUL;
    public static ExteriorVariantSchema PLINTH_FIRE;
    public static ExteriorVariantSchema RENEGADE_DEFAULT;
    public static ExteriorVariantSchema RENEGADE_TRON;
    public static ExteriorVariantSchema RENEGADE_CABINET;
    public static ExteriorVariantSchema BOOKSHELF_DEFAULT;
    public static ExteriorVariantSchema GEOMETRIC_DEFAULT;
    public static ExteriorVariantSchema GEOMETRIC_FIRE;
    public static ExteriorVariantSchema GEOMETRIC_SOUL;
    public static ExteriorVariantSchema GEOMETRIC_GILDED;
    public static ExteriorVariantSchema STALLION_DEFAULT;
    public static ExteriorVariantSchema STALLION_FIRE;
    public static ExteriorVariantSchema STALLION_SOUL;
    public static ExteriorVariantSchema STALLION_STEEL;
    public static ExteriorVariantSchema ADAPTIVE;
    public static ExteriorVariantSchema DALEK_MOD_1963;
    public static ExteriorVariantSchema DALEK_MOD_1967;
    public static ExteriorVariantSchema DALEK_MOD_1970;
    public static ExteriorVariantSchema DALEK_MOD_1976;
    public static ExteriorVariantSchema DALEK_MOD_1980;
    public static ExteriorVariantSchema PIPE_DEFAULT;
    public static ExteriorVariantSchema PIPE_RED;
    public static ExteriorVariantSchema PIPE_BLUE;
    public static ExteriorVariantSchema DOOM;
    public static ExteriorVariantSchema WANDERER;

    protected ExteriorVariantRegistry() {
        super(DatapackExterior::fromInputStream, null, "exterior", true);
    }

    public ExteriorVariantSchema fallback() {
        return CAPSULE_DEFAULT;
    }

    public void onCommonInit() {
        super.onCommonInit();
        this.defaults();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    public void syncToClient(class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        class_2540 secondary = PacketByteBufs.create();
        int counter = 0;
        for (ExteriorVariantSchema schema : this.toList()) {
            if (!(schema instanceof DatapackExterior)) continue;
            DatapackExterior type = (DatapackExterior)schema;
            ++counter;
            secondary.method_49395(DatapackExterior.CODEC, (Object)type);
        }
        buf.writeInt(counter);
        buf.writeBytes((ByteBuf)secondary);
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.packet, (class_2540)buf);
    }

    public void readFromServer(class_2540 buf) {
        DatapackExterior type;
        class_2540 copy = PacketByteBufs.copy((ByteBuf)buf);
        for (ExteriorVariantSchema schema : this.toList()) {
            if (!(schema instanceof DatapackExterior)) continue;
            type = (DatapackExterior)schema;
            this.REGISTRY.remove(type.id());
        }
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            type = (DatapackExterior)buf.method_49394(DatapackExterior.CODEC);
            this.register(type);
        }
        ClientExteriorVariantRegistry.getInstance().readFromServer(copy);
    }

    public static ExteriorVariantRegistry getInstance() {
        if (INSTANCE == null) {
            AITMod.LOGGER.debug("ExteriorVariantRegistry was not initialized, Creating a new instance");
            INSTANCE = new ExteriorVariantRegistry();
        }
        return INSTANCE;
    }

    public static List<ExteriorVariantSchema> withParent(ExteriorCategorySchema parent) {
        ArrayList<ExteriorVariantSchema> list = new ArrayList<ExteriorVariantSchema>();
        for (ExteriorVariantSchema schema : ExteriorVariantRegistry.getInstance().REGISTRY.values()) {
            if (!schema.category().equals(parent)) continue;
            list.add(schema);
        }
        return list;
    }

    public ExteriorVariantSchema pickRandomWithParent(ExteriorCategorySchema parent, Random random) {
        return (ExteriorVariantSchema)DatapackRegistry.getRandom(ExteriorVariantRegistry.withParent(parent), (Random)random, this::fallback);
    }

    public ExteriorVariantSchema pickRandomWithParent(ExteriorCategorySchema parent) {
        return this.pickRandomWithParent(parent, RANDOM);
    }

    protected void defaults() {
        ((AITRegistryEvents.Defaults)AITRegistryEvents.EXTERIOR_DEFAULTS.invoker()).defaults();
        TARDIM_DEFAULT = (ExteriorVariantSchema)this.register(new TardimDefaultVariant());
        TARDIM_FIRE = (ExteriorVariantSchema)this.register(new TardimFireVariant());
        TARDIM_SOUL = (ExteriorVariantSchema)this.register(new TardimSoulVariant());
        BOX_DEFAULT = (ExteriorVariantSchema)this.register(new PoliceBoxDefaultVariant());
        BOX_SOUL = (ExteriorVariantSchema)this.register(new PoliceBoxSoulVariant());
        BOX_FIRE = (ExteriorVariantSchema)this.register(new PoliceBoxFireVariant());
        BOX_FUTURE = (ExteriorVariantSchema)this.register(new PoliceBoxFuturisticVariant());
        BOX_CORAL = (ExteriorVariantSchema)this.register(new PoliceBoxCoralVariant());
        BOX_RENAISSANCE = (ExteriorVariantSchema)this.register(new PoliceBoxRenaissanceVariant());
        BOX_CHERRY = (ExteriorVariantSchema)this.register(new PoliceBoxCherryVariant());
        PRIME = (ExteriorVariantSchema)this.register(new ClassicBoxPrimeVariant());
        YETI = (ExteriorVariantSchema)this.register(new ClassicBoxYetiVariant());
        HUDOLIN = (ExteriorVariantSchema)this.register(new ClassicBoxHudolinVariant());
        DEFINITIVE = (ExteriorVariantSchema)this.register(new ClassicBoxDefinitiveVariant());
        PTORED = (ExteriorVariantSchema)this.register(new ClassicBoxPtoredVariant());
        MINT = (ExteriorVariantSchema)this.register(new ClassicBoxMintVariant());
        SHALKA = (ExteriorVariantSchema)this.register(new ClassicBoxShalkaVariant());
        EXILE = (ExteriorVariantSchema)this.register(new ClassicBoxExileVariant());
        CAPSULE_DEFAULT = (ExteriorVariantSchema)this.register(new CapsuleDefaultVariant());
        CAPSULE_SOUL = (ExteriorVariantSchema)this.register(new CapsuleSoulVariant());
        CAPSULE_FIRE = (ExteriorVariantSchema)this.register(new CapsuleFireVariant());
        BOOTH_DEFAULT = (ExteriorVariantSchema)this.register(new BoothDefaultVariant());
        BOOTH_FIRE = (ExteriorVariantSchema)this.register(new BoothFireVariant());
        BOOTH_SOUL = (ExteriorVariantSchema)this.register(new BoothSoulVariant());
        BOOTH_VINTAGE = (ExteriorVariantSchema)this.register(new BoothVintageVariant());
        BOOTH_BLUE = (ExteriorVariantSchema)this.register(new BoothBlueVariant());
        BOOTH_GILDED = (ExteriorVariantSchema)this.register(new BoothGildedVariant());
        HEAD_DEFAULT = (ExteriorVariantSchema)this.register(new EasterHeadDefaultVariant());
        HEAD_SOUL = (ExteriorVariantSchema)this.register(new EasterHeadSoulVariant());
        HEAD_FIRE = (ExteriorVariantSchema)this.register(new EasterHeadFireVariant());
        CORAL_GROWTH = (ExteriorVariantSchema)this.register(new CoralGrowthVariant());
        PLINTH_DEFAULT = (ExteriorVariantSchema)this.register(new PlinthDefaultVariant());
        PLINTH_SOUL = (ExteriorVariantSchema)this.register(new PlinthSoulVariant());
        PLINTH_FIRE = (ExteriorVariantSchema)this.register(new PlinthFireVariant());
        RENEGADE_DEFAULT = (ExteriorVariantSchema)this.register(new RenegadeDefaultVariant());
        RENEGADE_TRON = (ExteriorVariantSchema)this.register(new RenegadeTronVariant());
        RENEGADE_CABINET = (ExteriorVariantSchema)this.register(new RenegadeCabinetVariant());
        BOOKSHELF_DEFAULT = (ExteriorVariantSchema)this.register(new BookshelfDefaultVariant());
        GEOMETRIC_DEFAULT = (ExteriorVariantSchema)this.register(new GeometricDefaultVariant());
        GEOMETRIC_FIRE = (ExteriorVariantSchema)this.register(new GeometricFireVariant());
        GEOMETRIC_SOUL = (ExteriorVariantSchema)this.register(new GeometricSoulVariant());
        GEOMETRIC_GILDED = (ExteriorVariantSchema)this.register(new GeometricGildedVariant());
        STALLION_DEFAULT = (ExteriorVariantSchema)this.register(new StallionDefaultVariant());
        STALLION_FIRE = (ExteriorVariantSchema)this.register(new StallionFireVariant());
        STALLION_SOUL = (ExteriorVariantSchema)this.register(new StallionSoulVariant());
        STALLION_STEEL = (ExteriorVariantSchema)this.register(new StallionSteelVariant());
        ADAPTIVE = (ExteriorVariantSchema)this.register(new AdaptiveVariant());
        DALEK_MOD_1963 = (ExteriorVariantSchema)this.register(new DalekMod1963Variant());
        DALEK_MOD_1967 = (ExteriorVariantSchema)this.register(new DalekMod1967Variant());
        DALEK_MOD_1970 = (ExteriorVariantSchema)this.register(new DalekMod1970Variant());
        DALEK_MOD_1976 = (ExteriorVariantSchema)this.register(new DalekMod1976Variant());
        DALEK_MOD_1980 = (ExteriorVariantSchema)this.register(new DalekMod1980Variant());
        PIPE_DEFAULT = (ExteriorVariantSchema)this.register(new PipeDefaultVariant());
        PIPE_RED = (ExteriorVariantSchema)this.register(new PipeRedVariant());
        PIPE_BLUE = (ExteriorVariantSchema)this.register(new PipeBlueVariant());
        DOOM = (ExteriorVariantSchema)this.register(new DoomVariant());
        WANDERER = (ExteriorVariantSchema)this.register(new BoothWandererVariant());
    }
}

