/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.data;

import dev.amble.ait.data.Exclude;
import dev.amble.lib.data.DirectedGlobalPos;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class CachedDirectedGlobalPos
extends DirectedGlobalPos {
    @Exclude
    private class_3218 world;

    private CachedDirectedGlobalPos(class_5321<class_1937> key, class_2338 pos, byte rotation) {
        super(key, pos, rotation);
    }

    private CachedDirectedGlobalPos(class_3218 world, class_2338 pos, byte rotation) {
        this((class_5321<class_1937>)world.method_27983(), pos, rotation);
        this.world = world;
    }

    public static CachedDirectedGlobalPos create(class_3218 world, class_2338 pos, byte rotation) {
        return new CachedDirectedGlobalPos(world, pos, rotation);
    }

    public static CachedDirectedGlobalPos create(class_5321<class_1937> world, class_2338 pos, byte rotation) {
        return new CachedDirectedGlobalPos(world, pos, rotation);
    }

    private static CachedDirectedGlobalPos createSame(class_3218 world, class_5321<class_1937> dimension, class_2338 pos, byte rotation) {
        if (world == null) {
            return new CachedDirectedGlobalPos(dimension, pos, rotation);
        }
        return CachedDirectedGlobalPos.create(world, pos, rotation);
    }

    private static CachedDirectedGlobalPos createNew(class_3218 lastWorld, class_5321<class_1937> newWorldKey, class_2338 pos, byte rotation) {
        if (lastWorld == null) {
            return new CachedDirectedGlobalPos(newWorldKey, pos, rotation);
        }
        class_3218 newWorld = lastWorld;
        if (lastWorld.method_27983() != newWorldKey) {
            newWorld = lastWorld.method_8503().method_3847(newWorldKey);
        }
        return CachedDirectedGlobalPos.create(newWorld, pos, rotation);
    }

    public void init(MinecraftServer server) {
        if (this.world == null) {
            this.world = server.method_3847(this.getDimension());
        }
    }

    public class_3218 getWorld() {
        return this.world;
    }

    public CachedDirectedGlobalPos offset(int x, int y, int z) {
        return this.pos(this.getPos().method_10069(x, y, z));
    }

    public CachedDirectedGlobalPos world(class_5321<class_1937> dimension) {
        return CachedDirectedGlobalPos.createNew(this.world, dimension, this.getPos(), this.getRotation());
    }

    public CachedDirectedGlobalPos pos(class_2338 pos) {
        return CachedDirectedGlobalPos.createSame(this.world, (class_5321<class_1937>)this.getDimension(), pos, this.getRotation());
    }

    public CachedDirectedGlobalPos pos(int x, int y, int z) {
        return this.pos(new class_2338(x, y, z));
    }

    public CachedDirectedGlobalPos rotation(byte rotation) {
        return CachedDirectedGlobalPos.createSame(this.world, (class_5321<class_1937>)this.getDimension(), this.getPos(), rotation);
    }

    public CachedDirectedGlobalPos world(class_3218 world) {
        return CachedDirectedGlobalPos.create(world, this.getPos(), this.getRotation());
    }

    public static CachedDirectedGlobalPos fromNbt(class_2487 compound) {
        class_2338 pos = class_2512.method_10691((class_2487)compound);
        class_5321 dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(compound.method_10558("dimension")));
        byte rotation = compound.method_10571("rotation");
        return CachedDirectedGlobalPos.createNew(null, (class_5321<class_1937>)dimension, pos, rotation);
    }

    public static CachedDirectedGlobalPos read(class_2540 buf) {
        class_5321 registryKey = buf.method_44112(class_7924.field_41223);
        class_2338 blockPos = buf.method_10811();
        byte rotation = buf.readByte();
        return CachedDirectedGlobalPos.createNew(null, (class_5321<class_1937>)registryKey, blockPos, rotation);
    }
}

