/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.register.unlockable;

import com.mojang.serialization.Codec;
import dev.amble.ait.AITMod;
import dev.amble.ait.core.tardis.Tardis;
import dev.amble.ait.data.Loyalty;
import dev.amble.lib.register.datapack.DatapackRegistry;
import dev.amble.lib.register.datapack.SimpleDatapackRegistry;
import dev.amble.lib.register.unlockable.Unlockable;
import java.io.InputStream;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2960;

public abstract class UnlockableRegistry<T extends Unlockable>
extends SimpleDatapackRegistry<T> {
    protected UnlockableRegistry(Function<InputStream, T> deserializer, Codec<T> codec, class_2960 packet, class_2960 name, boolean sync) {
        super(deserializer, codec, packet, name, sync);
    }

    protected UnlockableRegistry(Function<InputStream, T> deserializer, Codec<T> codec, String packet, String name, boolean sync, String modid) {
        super(deserializer, codec, packet, name, sync, modid);
    }

    protected UnlockableRegistry(Function<InputStream, T> deserializer, Codec<T> codec, String name, boolean sync, String modid) {
        super(deserializer, codec, name, sync, modid);
    }

    protected UnlockableRegistry(Function<InputStream, T> deserializer, Codec<T> codec, String name, boolean sync) {
        this(deserializer, codec, name, sync, "ait");
    }

    @Deprecated
    public T getRandom(Random random) {
        AITMod.LOGGER.warn("Using plain random in an unlockable registry! Class: {}", ((Object)((Object)this)).getClass());
        return (T)((Unlockable)super.getRandom(random));
    }

    @Deprecated
    public T getRandom() {
        return (T)((Unlockable)super.getRandom());
    }

    public T getRandom(Tardis tardis, Random random) {
        return (T)((Unlockable)DatapackRegistry.getRandom(this.toList().stream().filter(tardis::isUnlocked).toList(), (Random)random, () -> ((UnlockableRegistry)this).fallback()));
    }

    public T getRandom(Tardis tardis) {
        return this.getRandom(tardis, RANDOM);
    }

    public boolean tryUnlock(Tardis tardis, Loyalty loyalty, Consumer<T> consumer) {
        boolean success = false;
        for (Unlockable schema : this.REGISTRY.values()) {
            Optional<Loyalty> optional;
            if (tardis.isUnlocked(schema) || (optional = schema.requirement()).isEmpty() || loyalty.smallerThan(optional.get())) continue;
            AITMod.LOGGER.debug("Unlocked {} {} for tardis [{}]", new Object[]{schema.unlockType(), schema.id(), tardis.getUuid()});
            success = true;
            tardis.stats().unlock(schema);
            if (consumer == null) continue;
            consumer.accept(schema);
        }
        return success;
    }

    public void unlockAll(Tardis tardis) {
        for (Unlockable schema : this.REGISTRY.values()) {
            tardis.stats().unlock(schema);
        }
        AITMod.LOGGER.debug("Unlocked everything from {} registry for tardis [{}]", ((Object)((Object)this)).getClass(), (Object)tardis.getUuid());
    }
}

