/*
 * Decompiled with CFR 0.152.
 */
package dev.drtheo.gaslighter;

import dev.drtheo.gaslighter.api.FakeBlockEvents;
import dev.drtheo.gaslighter.api.Twitter;
import dev.drtheo.gaslighter.impl.FakeChunkSection;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2637;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;

public class Gaslighter3000 {
    private final class_3218 world;
    private final Map<class_1923, ChunkHolder> lookup = new HashMap<class_1923, ChunkHolder>();

    public Gaslighter3000(class_3218 world) {
        this.world = world;
    }

    public void spreadLies(class_2338 pos, class_2680 state) {
        ((FakeBlockEvents.Place)FakeBlockEvents.PLACED.invoker()).onPlace(this.world, state, pos);
        this.lookup.computeIfAbsent(new class_1923(pos), chunkPos -> new ChunkHolder(this.world, (class_1923)chunkPos)).spreadLies(pos, state);
    }

    public void touchGrass(class_2338 pos) {
        ChunkHolder holder = this.lookup.get(new class_1923(pos));
        if (holder == null) {
            return;
        }
        holder.touchGrass(pos);
    }

    public class_2680 getAgenda(class_2338 pos) {
        ChunkHolder holder = this.lookup.get(new class_1923(pos));
        if (holder == null) {
            return this.world.method_8320(pos);
        }
        return holder.getAgenda(pos);
    }

    public void touchGrass() {
        this.lookup.values().forEach(ChunkHolder::touchGrass);
    }

    public void tweet() {
        for (ChunkHolder holder : this.lookup.values()) {
            holder.tweet();
        }
    }

    public void tweet(class_3222 player) {
        for (ChunkHolder holder : this.lookup.values()) {
            holder.tweet(player);
        }
    }

    static class ChunkHolder {
        private final class_3218 world;
        private final class_1923 pos;
        private final ShortSet[] blockUpdatesBySection;
        private final FakeChunkSection[] sections;

        public ChunkHolder(class_3218 world, class_1923 pos) {
            this.world = world;
            this.pos = pos;
            this.blockUpdatesBySection = new ShortSet[world.method_32890()];
            this.sections = new FakeChunkSection[this.blockUpdatesBySection.length];
        }

        public void spreadLies(class_2338 pos, class_2680 state) {
            int i = this.world.method_31602(pos.method_10264());
            if (this.sections[i] == null) {
                this.sections[i] = new FakeChunkSection(this.world);
            }
            this.sections[i].method_16675(pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF, state);
            class_3218 class_32182 = this.world;
            if (class_32182 instanceof Twitter) {
                Twitter twitter = (Twitter)class_32182;
                twitter.ait$setFake(pos, true);
            }
            this.markForBlockUpdate(pos, i);
        }

        public void touchGrass(class_2338 pos) {
            int i = this.world.method_31602(pos.method_10264());
            if (this.sections[i] == null) {
                return;
            }
            this.sections[i].method_16675(pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF, this.world.method_8320(pos));
            class_3218 class_32182 = this.world;
            if (class_32182 instanceof Twitter) {
                Twitter twitter = (Twitter)class_32182;
                twitter.ait$setFake(pos, false);
            }
            this.markForBlockUpdate(pos, i);
            ((FakeBlockEvents.Remove)FakeBlockEvents.REMOVED.invoker()).onRemove(this.world, pos);
        }

        public void touchGrass() {
            for (int i = 0; i < this.sections.length; ++i) {
                ShortSet updates = this.blockUpdatesBySection[i];
                if (updates == null) continue;
                int coord = this.world.method_31604(i);
                class_4076 csp = class_4076.method_18681((class_1923)this.pos, (int)coord);
                ShortIterator shortIterator = updates.iterator();
                while (shortIterator.hasNext()) {
                    short update = (Short)shortIterator.next();
                    this.touchGrass(csp.method_30557(update));
                }
            }
        }

        public class_2680 getAgenda(class_2338 pos) {
            int i = this.world.method_31602(pos.method_10264());
            if (this.sections[i] == null) {
                return this.world.method_8320(pos);
            }
            return this.sections[i].method_12254(pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF);
        }

        private void markForBlockUpdate(class_2338 pos, int i) {
            if (this.blockUpdatesBySection[i] == null) {
                this.blockUpdatesBySection[i] = new ShortOpenHashSet();
            }
            this.blockUpdatesBySection[i].add(class_4076.method_19454((class_2338)pos));
        }

        private void unmarkForBlockUpdate(class_2338 pos, int i) {
            if (this.blockUpdatesBySection[i] == null) {
                return;
            }
            this.blockUpdatesBySection[i].remove(class_4076.method_19454((class_2338)pos));
        }

        private void makeTweetPackets(Consumer<class_2637> consumer) {
            for (int i = 0; i < this.blockUpdatesBySection.length; ++i) {
                ShortSet shortSet = this.blockUpdatesBySection[i];
                if (shortSet == null) continue;
                int j = this.world.method_31604(i);
                class_4076 chunkSectionPos = class_4076.method_18681((class_1923)this.pos, (int)j);
                consumer.accept(new class_2637(chunkSectionPos, shortSet, (class_2826)this.sections[i]));
            }
        }

        public void tweet() {
            Collection list = PlayerLookup.tracking((class_3218)this.world, (class_1923)this.pos);
            if (list.isEmpty()) {
                return;
            }
            this.makeTweetPackets(packet -> ChunkHolder.sendPacketToPlayers(list, packet));
        }

        public void tweet(class_3222 player) {
            this.makeTweetPackets(packet -> player.field_13987.method_14364((class_2596)packet));
        }

        private static void sendPacketToPlayers(Collection<class_3222> players, class_2596<?> packet) {
            players.forEach(player -> player.field_13987.method_14364(packet));
        }
    }
}

