package dev.amble.lib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.amble.lib.animation.AnimationTracker;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import dev.amble.lib.client.bedrock.BedrockAnimationAdapter;
import dev.amble.lib.client.bedrock.BedrockModel;
import dev.amble.lib.command.PlayAnimationCommand;
import dev.amble.lib.command.SetSkinCommand;
import dev.amble.lib.skin.SkinTracker;
import dev.drtheo.multidim.MultiDimMod;
import dev.drtheo.scheduler.SchedulerMod;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import dev.amble.lib.api.AmbleKitInitializer;
import dev.amble.lib.register.AmbleRegistries;
import dev.amble.lib.util.ServerLifecycleHooks;

public class AmbleKit implements ModInitializer {
    public static final String MOD_ID = "amblekit";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	public static final Gson GSON = new GsonBuilder().create();

    @Override
    public void onInitialize() {
        AmbleRegistries.getInstance();
        ServerLifecycleHooks.init();
		SkinTracker.init();
		AnimationTracker.init();

		CommandRegistrationCallback.EVENT.register((dispatcher, access, env) -> {
			SetSkinCommand.register(dispatcher);
			PlayAnimationCommand.register(dispatcher);
		});

        FabricLoader.getInstance().invokeEntrypoints("amblekit-main", AmbleKitInitializer.class,
                AmbleKitInitializer::onInitialize);
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }
}