package dev.amble.lib.advancement;

import com.google.gson.JsonObject;
import dev.amble.lib.AmbleKit;
import net.minecraft.class_174;
import net.minecraft.class_195;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import org.jetbrains.annotations.ApiStatus;

public class SimpleCriterion extends class_4558<SimpleCriterion.Conditions> {
    protected final class_2960 id;

    protected SimpleCriterion(class_2960 id) {
        this.id = id;
    }

    @Override
    protected SimpleCriterion.Conditions method_27854(JsonObject obj,
                                                            class_5258 playerPredicate, class_5257 predicateDeserializer) {
        return this.conditions();
    }


    @Override
    public class_2960 method_794() {
        return this.id;
    }

    public void trigger(class_3222 player) {
        this.method_22510(player, SimpleCriterion.Conditions::requirementsMet);
    }

    /**
     * @return a newly created conditions object
     */
    public Conditions conditions() {
        return new Conditions(this.id);
    }

    public SimpleCriterion register() {
        AmbleKit.LOGGER.info("Registering criterion: {}", this.id);

        class_174.method_767(this);
        return this;
    }

    public static SimpleCriterion create(class_2960 id) {
        return new SimpleCriterion(id);
    }

    @ApiStatus.Internal
    public static SimpleCriterion create(String name) {
        return new SimpleCriterion(AmbleKit.id(name));
    }

    public static class Conditions extends class_195 {
        public Conditions(class_2960 id) {
            super(id, class_5258.field_24388);
        }

        boolean requirementsMet() {
            return true;
        }
    }
}
