package dev.amble.lib.animation;

import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3419;

/**
 * An interface for block entities that can have animations.
 * Provides a default implementation for generating a UUID based on the block entity's position and world.
 * Note: This implementation assumes that the block entity is in a loaded world.
 * getAge should be implemented with a private int age field incremented each tick in the block entity's tick method.
 */
public interface AnimatedBlockEntity extends AnimatedInstance {
	@Override
	default UUID getUuid() {
		if (!(this instanceof class_2586 be)) {
			throw new UnsupportedOperationException("getUuid() is only supported for BlockEntity instances. Override this method");
		}

		class_2338 pos = be.method_11016();
		return new UUID(be.method_10997().method_27983().method_29177().hashCode(), pos.method_10063());
	}

	@Override
	default class_1937 getWorld() {
		if (!(this instanceof class_2586 be)) {
			throw new UnsupportedOperationException("getWorld() is only supported for BlockEntity instances. Override this method");
		}

		return be.method_10997();
	}

	@Override
	default boolean isSilent() {
		return false;
	}

	@Override
	default class_3419 getSoundCategory() {
		return class_3419.field_15245;
	}

	@Override
	default class_243 getEffectPosition(float tickDelta) {
		if (!(this instanceof class_2586 be)) {
			throw new UnsupportedOperationException("getSoundPosition() is only supported for BlockEntity instances. Override this method");
		}

		return class_243.method_24953(be.method_11016());
	}

	@Override
	default float getHeadYaw() {
		return 0;
	}

	@Override
	default float getBodyYaw() {
		return 0;
	}

	@Override
	default float getPitch() {
		return 0;
	}
}
