package dev.amble.lib.animation;

import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import dev.amble.lib.client.bedrock.BedrockModel;
import dev.amble.lib.client.bedrock.BedrockModelReference;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5568;
import org.jetbrains.annotations.Nullable;

public interface AnimatedEntity extends class_5568, AnimatedInstance {
	@Override
	default int getAge() {
		if (this instanceof class_1297 entity) {
			return entity.field_6012;
		}

		throw new UnsupportedOperationException("getAge() is only supported for Entity instances. Override this method");
	}

	@Nullable
	static AnimatedEntity getInstance(class_5568 entity) {
		if (entity instanceof AnimatedEntity animated) {
			return animated;
		}
		return null;
	}

	@Override
	default class_1937 getWorld() {
		if (!(this instanceof class_1297 be)) {
			throw new UnsupportedOperationException("getWorld() is only supported for Entity instances. Override this method");
		}

		return be.method_37908();
	}

	@Override
	default boolean isSilent() {
		if (!(this instanceof class_1297 be)) {
			throw new UnsupportedOperationException("isSilent() is only supported for Entity instances. Override this method");
		}

		return be.method_5701();
	}

	@Override
	default class_3419 getSoundCategory() {
		if (!(this instanceof class_1297 be)) {
			throw new UnsupportedOperationException("getSoundCategory() is only supported for Entity instances. Override this method");
		}

		return be.method_5634();
	}

	@Override
	default class_243 getEffectPosition(float tickDelta) {
		if (!(this instanceof class_1297 entity)) throw new UnsupportedOperationException("getEffectPosition() is only supported for Entity instances. Override this method");

		return new class_243(
				class_3532.method_16436(tickDelta, entity.field_6014, entity.method_23317()),
				class_3532.method_16436(tickDelta, entity.field_6036, entity.method_23318()),
				class_3532.method_16436(tickDelta, entity.field_5969, entity.method_23321()));
	}
}
