package dev.amble.lib.animation;

import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_7094;

public interface AnimatedInstance extends BedrockModelProvider, EffectProvider {
	UUID getUuid();
	int getAge();
	class_7094 getAnimationState();

	default void playAnimation(BedrockAnimationReference animation) {
		getAnimationState().method_41322(this.getAge());
		AnimationTracker.getInstance().add(this.getUuid(), animation);
	}

	@Nullable
	default BedrockAnimationReference getCurrentAnimation() {
		return AnimationTracker.getInstance().get(this);
	}

	default boolean isAnimationDirty() {
		return AnimationTracker.getInstance().isDirty(this);
	}
}
