package dev.amble.lib.animation;

import dev.amble.lib.AmbleKit;
import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import dev.amble.lib.client.bedrock.BedrockAnimationRegistry;
import dev.amble.lib.util.ServerLifecycleHooks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class AnimationTracker {
	private static final AnimationTracker INSTANCE = new AnimationTracker();
	public static final class_2960 SYNC_KEY = AmbleKit.id("animation_sync");

	public static AnimationTracker getInstance() {
		return INSTANCE;
	}

	public static void init() {
		ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
			getInstance().sync(handler.method_32311());
		});

		if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
			initClient();
		}
	}

	@Environment(EnvType.CLIENT)
	private static void initClient() {
		ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
			getInstance().clear();
		});

		ClientPlayNetworking.registerGlobalReceiver(SYNC_KEY, ((client, handler, buf, responseSender) -> {
			getInstance().receive(buf);
		}));

	}

	private final HashMap<UUID, BedrockAnimationReference> animations = new HashMap<>();
	private final Set<UUID> updated = new HashSet<>(); // entities which have been updated recently

	@Nullable
	public BedrockAnimationReference get(AnimatedInstance entity) {
		return this.animations.get(entity.getUuid());
	}

	public void add(UUID id, BedrockAnimationReference animation) {
		this.animations.put(id, animation);

		sync(toBuf(id, animation));
	}

	public void add(AnimatedInstance entity, BedrockAnimationReference animation) {
		this.add(entity.getUuid(), animation);
	}

	public void removeLocal(UUID id) {
		this.animations.remove(id);
	}

	public void removeLocal(AnimatedInstance entity) {
		this.removeLocal(entity.getUuid());
	}

	public void remove(UUID id) {
		this.removeLocal(id);

		sync(toRemovalBuf(id));
	}

	public void remove(AnimatedInstance entity) {
		this.remove(entity.getUuid());
	}

	public boolean isDirty(AnimatedInstance entity) {
		return this.updated.remove(entity.getUuid());
	}

	private void clear() {
		this.animations.clear();
	}

	private class_2540 toBuf(Map<UUID, BedrockAnimationReference> map) {
		class_2540 buf = PacketByteBufs.create();

		buf.writeInt(map.size());
		for (Map.Entry<UUID, BedrockAnimationReference> entry : map.entrySet()) {
			buf.method_10797(entry.getKey());
			buf.method_10812(entry.getValue().id());
		}

		return buf;
	}

	private class_2540 toBuf() {
		return toBuf(this.animations);
	}

	private class_2540 toBuf(UUID id, BedrockAnimationReference animation) {
		class_2540 buf = PacketByteBufs.create();

		buf.writeInt(1);
		buf.method_10797(id);
		buf.method_10812(animation.id());

		return buf;
	}

	private class_2540 toRemovalBuf(UUID id) {
		class_2540 buf = PacketByteBufs.create();

		buf.writeInt(-1);
		buf.method_10797(id);

		return buf;
	}

	private void receive(class_2540 buf) {
		int count = buf.readInt();

		if (count == -1) {
			UUID id = buf.method_10790();
			this.animations.remove(id);
			return;
		}

		for (int i = 0; i < count; i++) {
			UUID id = buf.method_10790();
			BedrockAnimationReference reference = BedrockAnimationReference.parse(buf.method_10810());

			this.animations.put(id, reference);
			this.updated.add(id);
		}
	}

	public void sync() {
		sync(toBuf());
	}

	public void sync(class_3222 target) {
		sync(toBuf(), target);
	}

	private void sync(class_2540 buf) {
		ServerLifecycleHooks.get().method_3760().method_14571().forEach((p) -> this.sync(buf, p));
	}

	private void sync(class_2540 buf, class_3222 player) {
		ServerPlayNetworking.send(player, SYNC_KEY, buf);
	}
}
