package dev.amble.lib.animation;

import dev.amble.lib.client.bedrock.BedrockModelReference;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public interface BedrockModelProvider {
	@Nullable
	default BedrockModelReference getModel() {
		return null;
	}

	@Nullable
	default class_2960 getTexture() {
		if (getModel() == null) return null;

		BedrockModelReference model = getModel();
		class_2960 id = model.id();

		String prefix = getTexturePrefix();
		if (!prefix.isEmpty() && !prefix.endsWith("/")) {
			prefix += "/";
		}

		String namespace = getModId();
		if (namespace.isEmpty()) {
			namespace = id.method_12836();
		}

		return class_2960.method_43902(namespace, "textures/" + prefix + model.id().method_12832() + ".png");
	}

	@Nullable
	default class_2960 getEmissionTexture() {
		if (!hasEmission()) return null;

		class_2960 texture = getTexture();
		if (texture == null) return null;

		// add _emission suffix
		return class_2960.method_43902(texture.method_12836(), texture.method_12832().replace(".png", "_emission.png"));
	}

	default boolean hasEmission() {
		return false;
	}

	default String getModId() {
		return "";
	}

	default String getTexturePrefix() {
		return "";
	}
}
