package dev.amble.lib.animation.client;

import dev.amble.lib.AmbleKit;
import dev.amble.lib.animation.AnimatedInstance;
import dev.amble.lib.animation.AnimationTracker;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import lombok.extern.slf4j.Slf4j;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_1297;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_7094;
import java.util.Optional;

@Environment(EnvType.CLIENT)
public interface AnimatedEntityModel {
	/**
	 * @return the root modelpart of the renderer
	 */
	class_630 getPart();

	default Optional<class_630> getChild(String name) {
		if (name.equals("root") || name.equalsIgnoreCase("player")) {
			return Optional.of(this.getPart());
		}
		return this.getPart().method_32088().filter(part -> part.method_41919(name)).findFirst().map(part -> part.method_32086(name));
	}

	/**
	 * Call this in {@link class_583#method_2819(class_1297, float, float, float, float, float)} where progress is usually named 'h'
	 */
	default void applyAnimation(AnimatedInstance entity, float progress) {
		BedrockAnimationReference reference = entity.getCurrentAnimation();

		if (reference == null) return;

		BedrockAnimation animation = reference.get().orElse(null);
		if (animation == null) {
			AmbleKit.LOGGER.error("Got unknown animation reference: {}", reference.id());
			AnimationTracker.getInstance().removeLocal(entity);
			return;
		}

		class_7094 state = entity.getAnimationState();

		if (entity.isAnimationDirty()) {
			state.method_41325();
			state.method_41324(entity.getAge());
		}

		if (animation.isFinished(state)) {
			AnimationTracker.getInstance().removeLocal(entity);
			return;
		}

		state.method_41324(entity.getAge());

		animation.apply(this.getPart(), state, progress, 1.0F, entity);
	}

	default void applyAnimationPre(AnimatedInstance entity, float progress) {
		BedrockAnimationReference reference = entity.getCurrentAnimation();

		if (reference == null) {
			this.getPart().method_32088().forEach(class_630::method_41923);
			return;
		}

		BedrockAnimation animation = reference.get().orElse(null);
		if (animation == null) {
			this.getPart().method_32088().forEach(class_630::method_41923);
			return;
		}

		class_7094 state = entity.getAnimationState();
		if (state == null || animation.isFinished(state)) {
			this.getPart().method_32088().forEach(class_630::method_41923);
			return;
		}

		if (animation.metadata != null && !animation.metadata.movement()) {
			this.getPart().method_32088().forEach(class_630::method_41923);
		}
	}
}