package dev.amble.lib.animation.client;

import dev.amble.lib.animation.EffectProvider;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import lombok.Getter;
import net.minecraft.class_1922;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import java.util.concurrent.atomic.AtomicReference;

public class WorldPosition {
	private static final WorldPosition INSTANCE = new WorldPosition();

	private class_1922 area;
	@Getter
	private class_243 pos = class_243.field_1353;
	private final Vector3f horizontalPlane = new Vector3f(0.0F, 0.0F, 1.0F);
	private final Vector3f verticalPlane = new Vector3f(0.0F, 1.0F, 0.0F);
	private final Vector3f diagonalPlane = new Vector3f(1.0F, 0.0F, 0.0F);
	@Getter
	private float pitch;
	@Getter
	private float yaw;
	private final Quaternionf rotation = new Quaternionf(0.0F, 0.0F, 0.0F, 1.0F);

	protected void moveBy(double x, double y, double z) {
		double d = (double) this.horizontalPlane.x() * x + (double) this.verticalPlane.x() * y + (double) this.diagonalPlane.x() * z;
		double e = (double) this.horizontalPlane.y() * x + (double) this.verticalPlane.y() * y + (double) this.diagonalPlane.y() * z;
		double f = (double) this.horizontalPlane.z() * x + (double) this.verticalPlane.z() * y + (double) this.diagonalPlane.z() * z;
		this.setPos(new class_243(this.pos.field_1352 + d, this.pos.field_1351 + e, this.pos.field_1350 + f));
	}

	protected void setRotation(float yaw, float pitch) {
		this.pitch = pitch;
		this.yaw = yaw;
		this.rotation.rotationYXZ(-yaw * (float) (Math.PI / 180.0), pitch * (float) (Math.PI / 180.0), 0.0F);
		this.horizontalPlane.set(0.0F, 0.0F, 1.0F).rotate(this.rotation);
		this.verticalPlane.set(0.0F, 1.0F, 0.0F).rotate(this.rotation);
		this.diagonalPlane.set(1.0F, 0.0F, 0.0F).rotate(this.rotation);
	}

	protected void setRotation(class_243 rotation) {
		class_3545<Float, Float> rots = BedrockAnimation.eulerToPitchYaw(rotation);

		this.pitch = rots.method_15442();
		this.yaw = rots.method_15441();

		this.rotation.rotationXYZ((float) rotation.method_10216(), (float) rotation.method_10214(), (float) rotation.method_10215());
		this.horizontalPlane.set(0.0F, 0.0F, 1.0F).rotate(this.rotation);
		this.verticalPlane.set(0.0F, 1.0F, 0.0F).rotate(this.rotation);
		this.diagonalPlane.set(1.0F, 0.0F, 0.0F).rotate(this.rotation);
	}

	protected void setPos(double x, double y, double z) {
		this.setPos(new class_243(x, y, z));
	}

	protected void setPos(class_243 pos) {
		this.pos = pos;
	}

	public void spawnParticle(class_2394 particle, class_243 velocity, int count) {
		if (!(this.area instanceof class_638 world)) return;

		for (int i = 0; i < count; i++) {
			world.method_8406(particle, this.pos.field_1352, this.pos.field_1351, this.pos.field_1350, velocity.field_1352, velocity.field_1351, velocity.field_1350);
		}
	}

	public WorldPosition update(BedrockAnimation anim, String boneName, float progress, EffectProvider target, class_630 root) {
		float tickDelta = class_310.method_1551().method_1488();

		this.area = target.getWorld();

		this.setPos(
			target.getEffectPosition(tickDelta)
		);

		class_243 position = anim.boneTimelines.containsKey(boneName) ? anim.boneTimelines.get(boneName).position().resolve(progress) : class_243.field_1353;
		class_243 animRotation = anim.boneTimelines.containsKey(boneName) ? anim.boneTimelines.get(boneName).rotation().resolve(progress) : class_243.field_1353;

		AtomicReference<Float> height = new AtomicReference<>((float) 0);
		AtomicReference<Float> lowest = new AtomicReference<>((float) 0);

		class_630 bone = root.method_32088().filter(part -> part.method_41919(boneName)).findFirst().map(part -> part.method_32086(boneName)).orElse(null);

		if (bone != null) {
			position = position.method_1031(bone.method_41921().field_27702, bone.method_41921().field_27703, bone.method_41921().field_27704);

			bone.method_35745(new class_4587(), (matrix, path, index, cuboid) -> {
				height.updateAndGet(v -> cuboid.field_3644 + bone.method_41921().field_27703 + -1.68F*16F);
			});

			root.method_35745(new class_4587(), (matrix, path, index, cuboid) -> {
				lowest.updateAndGet(v -> Math.max(v, cuboid.field_3647 + bone.method_41921().field_27703));
			});
		}

		class_3545<Float, Float> rots = anim.getRotations(boneName, progress);
		float animYaw = rots.method_15441();
		float animPitch = rots.method_15442();

		float entityYaw;

		if (anim.metadata.fpsCameraCopiesHead()) {
			entityYaw = (target instanceof class_746 clientPlayer) ? (class_3532.method_17821(tickDelta, clientPlayer.field_6259, clientPlayer.field_6241)) : target.getHeadYaw();
		} else {
			entityYaw = (target instanceof class_746 clientPlayer) ? (class_3532.method_17821(tickDelta, clientPlayer.field_6220, clientPlayer.field_6283)) : target.getBodyYaw();
		}

		float entityPitch = (target instanceof class_746 clientPlayer) ? (class_3532.method_16439(tickDelta, clientPlayer.field_6004, clientPlayer.method_5695(tickDelta))) : target.getPitch();

		class_243 relativePos = position.method_1024((float) Math.toRadians(90)).method_1021(-1 / 16F);
		this.setRotation(entityYaw, 0);
		// todo \/ the clipping causes the camera to break when on ground
		this.moveBy(relativePos.field_1352, relativePos.field_1351 + 1.68, relativePos.field_1350);
		//this.setRotation(animRotation);
		this.setRotation(animYaw + entityYaw, animPitch);

		this.moveBy(0, height.get() / 32F, 0);


		return this;
	}

	public static WorldPosition create(BedrockAnimation anim, String part, float progress, EffectProvider target, class_630 root) {
		return new WorldPosition().update(anim, part, progress, target, root);
	}

	public static WorldPosition get(BedrockAnimation anim, String part, float progress, EffectProvider target, class_630 root) {
		return INSTANCE.update(anim, part, progress, target, root);
	}
}
