package dev.amble.lib.api;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

/**
 * An interface which stops a block from being broken.
 */
public interface ICantBreak {
    /**
     * Called when the block was attempted to be broken.
     * This still exists for backwards compatibility, do NOT call.
     */
    default void onTryBreak(class_1937 world, class_2338 pos, class_2680 state) { }

    /**
     * Called when the block was attempted to be broken but also includes the player who attempts to break it.
     *
     * @param player The player who attempted to break the block, or null if not available.
     */
    default void onTryBreak(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        this.onTryBreak(world, pos, state);
    }
}
