package dev.amble.lib.api;

import dev.amble.lib.data.DirectedGlobalPos;
import dev.amble.lib.util.ServerLifecycleHooks;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_4076;
import net.minecraft.class_5321;

public class WorldUtil {
    private static final int SAFE_RADIUS = 3;

    public static DirectedGlobalPos locateSafe(DirectedGlobalPos cached,
                                               GroundSearch vSearch, boolean hSearch) {
        class_3218 world = ServerLifecycleHooks.get().method_3847(cached.getDimension());
        class_2338 pos = cached.getPos();

        if (isSafe(world, pos))
            return cached;

        if (hSearch) {
            class_2338 temp = findSafeXZ(world, pos, SAFE_RADIUS);

            if (temp != null)
                return cached.pos(temp);
        }

        int x = pos.method_10263();
        int z = pos.method_10260();

        int y = switch (vSearch) {
            case CEILING -> findSafeTopY(world, pos);
            case FLOOR -> findSafeBottomY(world, pos);
            case MEDIAN -> findSafeMedianY(world, pos);
            case NONE -> pos.method_10264();
        };

        return cached.pos(x, y, z);
    }

    private static class_2338 findSafeXZ(class_3218 world, class_2338 original, int radius) {
        class_2338.class_2339 pos = original.method_25503();

        int minX = pos.method_10263() - radius;
        int maxX = pos.method_10263() + radius;

        int minZ = pos.method_10260() - radius;
        int maxZ = pos.method_10260() + radius;

        for (int x = minX; x < maxX; x++) {
            for (int z = minZ; z < maxZ; z++) {
                pos.method_33097(x).method_33099(z);

                if (isSafe(world, pos))
                    return pos;
            }
        }

        return null;
    }

    private static int findSafeMedianY(class_3218 world, class_2338 pos) {
        class_2338 upCursor = pos;
        class_2680 floorUp = world.method_8320(upCursor.method_10074());
        class_2680 curUp = world.method_8320(upCursor);
        class_2680 aboveUp = world.method_8320(upCursor.method_10084());

        class_2338 downCursor = pos;
        class_2680 floorDown = world.method_8320(downCursor.method_10074());
        class_2680 curDown = world.method_8320(downCursor);
        class_2680 aboveDown = world.method_8320(downCursor.method_10084());

        while (true) {
            boolean canGoUp = upCursor.method_10264() < world.method_31600();
            boolean canGoDown = downCursor.method_10264() > world.method_31607();

            if (!canGoUp && !canGoDown)
                return pos.method_10264();

            if (canGoUp) {
                if (isSafe(floorUp, curUp, aboveUp))
                    return upCursor.method_10264() - 1;

                upCursor = upCursor.method_10084();

                floorUp = curUp;
                curUp = aboveUp;
                aboveUp = world.method_8320(upCursor);
            }

            if (canGoDown) {
                if (isSafe(floorDown, curDown, aboveDown))
                    return downCursor.method_10264() + 1;

                downCursor = downCursor.method_10074();

                curDown = aboveDown;
                aboveDown = floorDown;
                floorDown = world.method_8320(downCursor);
            }
        }
    }

    private static int findSafeBottomY(class_3218 world, class_2338 pos) {
        class_2338 cursor = pos.method_33096(world.method_31607() + 2);

        class_2680 floor = world.method_8320(cursor.method_10074());
        class_2680 current = world.method_8320(cursor);
        class_2680 above = world.method_8320(cursor.method_10084());

        while (true) {
            if (cursor.method_10264() > world.method_31600())
                return pos.method_10264();

            if (isSafe(floor, current, above))
                return cursor.method_10264() - 1;

            cursor = cursor.method_10084();

            floor = current;
            current = above;
            above = world.method_8320(cursor);
        }
    }

    private static int findSafeTopY(class_3218 world, class_2338 pos) {
        int x = pos.method_10263();
        int z = pos.method_10260();

        return world.method_8497(class_4076.method_18675(x), class_4076.method_18675(z))
                .method_12005(class_2902.class_2903.field_13203, x & 15, z & 15) + 1;
    }

    private static boolean isSafe(class_2680 floor, class_2680 block1, class_2680 block2) {
        return isFloor(floor) && !block1.method_51366() && !block2.method_51366();
    }

    private static boolean isSafe(class_2680 block1, class_2680 block2) {
        return !block1.method_51366() && !block2.method_51366();
    }

    private static boolean isFloor(class_2680 floor) {
        return floor.method_51366();
    }

    private static boolean isSafe(class_1937 world, class_2338 pos) {
        class_2680 floor = world.method_8320(pos.method_10074());

        if (!isFloor(floor))
            return false;

        class_2680 curUp = world.method_8320(pos);
        class_2680 aboveUp = world.method_8320(pos.method_10084());

        return isSafe(curUp, aboveUp);
    }

    public enum GroundSearch implements class_3542 {
        NONE {
            @Override
            public GroundSearch next() {
                return FLOOR;
            }
        },
        FLOOR {
            @Override
            public GroundSearch next() {
                return CEILING;
            }
        },
        CEILING {
            @Override
            public GroundSearch next() {
                return MEDIAN;
            }
        },
        MEDIAN {
            @Override
            public GroundSearch next() {
                return NONE;
            }
        };

        @Override
        public String method_15434() {
            return toString();
        }

        public abstract GroundSearch next();
    }

    public static class_2561 worldText(class_5321<class_1937> key) {
        return class_2561.method_48321(key.method_29177().method_42093("dimension"), fakeTranslate(key));
    }

    private static String fakeTranslate(class_5321<class_1937> id) {
        return fakeTranslate(id.method_29177());
    }

    private static String fakeTranslate(class_2960 id) {
        return fakeTranslate(id.method_12832());
    }

    private static String fakeTranslate(String path) {
        // Split the string into words
        String[] words = path.split("_");

        // Capitalize the first letter of each word
        for (int i = 0; i < words.length; i++) {
            words[i] = words[i].substring(0, 1).toUpperCase() + words[i].substring(1).toLowerCase();
        }

        // Join the words back together with spaces
        return String.join(" ", words);
    }
}