package dev.amble.lib.block.behavior.base;

import dev.amble.lib.block.behavior.InvisibleBlockBehavior;
import dev.amble.lib.block.behavior.api.Archetype;
import dev.amble.lib.block.behavior.api.BlockBehavior;
import dev.amble.lib.block.behavior.api.BlockBehaviors;
import dev.amble.lib.blockentity.ABlockEntity;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiFunction;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5558;

public class BlockWithEntityBehavior implements BlockBehavior {

    private final BiFunction<class_2338, class_2680, ? extends class_2586> func;

    public BlockWithEntityBehavior(BiFunction<class_2338, class_2680, ? extends class_2586> func) {
        this.func = func;
    }

    @Override
    public void init(class_2248 block) {
        if (!(block instanceof class_2343))
            throw new IllegalStateException("Block " + block.getClass() + " does not implement a block entity provider!");
    }

    public class_2586 createBlockEntity(class_2338 pos, class_2680 state) {
        return func.apply(pos, state);
    }

    public @Nullable <T extends class_2586> class_5558<T> getTicker(class_1937 world, class_2680 state, class_2591<T> type) {
        return null;
    }

    @Override
    public int idx() {
        return BlockBehaviors.BLOCK_WITH_ENTITY;
    }

    public static class Ticking extends BlockWithEntityBehavior {

        public Ticking(BiFunction<class_2338, class_2680, ? extends ABlockEntity> func) {
            super(func);
        }

        @Override
        public @Nullable <T extends class_2586> class_5558<T> getTicker(class_1937 world, class_2680 state, class_2591<T> type) {
            return ABlockEntity::tick;
        }

        public static Archetype withInvisibleModel(BiFunction<class_2338, class_2680, ? extends ABlockEntity> func) {
            return new Archetype(new Ticking(func), InvisibleBlockBehavior.behavior);
        }
    }
}
