package dev.amble.lib.block.behavior.horizontal;

import dev.amble.lib.block.behavior.base.BlockPlacementBehavior;
import net.minecraft.class_1750;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class HorizontalBlockPlacementBehavior extends BlockPlacementBehavior {

    public static final HorizontalBlockPlacementBehavior behaviorFacePlayer = new HorizontalBlockPlacementBehavior(true);
    public static final HorizontalBlockPlacementBehavior behavior = new HorizontalBlockPlacementBehavior(false);

    public static HorizontalBlockPlacementBehavior get(boolean facePlayer) {
        return facePlayer ? behaviorFacePlayer : behavior;
    }

    private final boolean facePlayer;

    public HorizontalBlockPlacementBehavior(boolean facePlayer) {
        this.facePlayer = facePlayer;
    }

    @Override
    public class_2680 getPlacementState(class_2680 state, class_1750 ctx) {
        class_2350 direction = ctx.method_8042();
        return state.method_11657(HorizontalBlockBehavior.FACING, facePlayer ? direction.method_10153() : direction);
    }
}
