package dev.amble.lib.client.bedrock;

import com.mojang.serialization.Codec;
import dev.amble.lib.api.Identifiable;
import java.util.Optional;
import net.minecraft.class_2960;

public record BedrockAnimationReference(String fileName, String animationName) implements Identifiable {
	public static Codec<BedrockAnimationReference> CODEC = class_2960.field_25139.xmap(
			BedrockAnimationReference::parse,
			BedrockAnimationReference::id
	);

	@Override
	public class_2960 id() {
		return class_2960.method_43902(fileName, animationName);
	}

	public Optional<BedrockAnimation> get() {
		BedrockAnimation animation = BedrockAnimationRegistry.getInstance().get(this);
		return Optional.ofNullable(animation);
	}

	public static BedrockAnimationReference parse(class_2960 id) {
		return new BedrockAnimationReference(id.method_12836(), id.method_12832());
	}
}
