package dev.amble.lib.client.bedrock;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.register.datapack.DatapackRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.apache.commons.lang3.NotImplementedException;

import java.io.InputStream;
import java.io.InputStreamReader;

@Environment(EnvType.CLIENT)
public class BedrockModelRegistry extends DatapackRegistry<BedrockModel> implements SimpleSynchronousResourceReloadListener {
	private static final BedrockModelRegistry INSTANCE = new BedrockModelRegistry();

	private BedrockModelRegistry() {
		ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(this);
	}

	@Override
	public BedrockModel fallback() {
		throw new NotImplementedException();
	}

	@Override
	public class_2960 getFabricId() {
		return AmbleKit.id("bedrock_model");
	}

	@Override
	public void method_14491(class_3300 manager) {
		clearCache();

		for (class_2960 rawId : manager.method_14488("bedrock", filename -> filename.method_12832().endsWith("geo.json")).keySet()) {
			try (InputStream stream = manager.method_14486(rawId).get().method_14482()) {
				String path = rawId.method_12832();
				// remove "bedrock/" prefix and ".geo.json" suffix
				String idPath = path.substring("bedrock/".length(), path.length() - ".geo.json".length());
				class_2960 id = class_2960.method_43902(rawId.method_12836(), idPath);

				JsonObject json = JsonParser.parseReader(new InputStreamReader(stream)).getAsJsonObject();
				BedrockModel model = BedrockModel.from(json, id);

				register(model);

				AmbleKit.LOGGER.debug("Loaded bedrock model {} {}", id, model);
			} catch (Exception e) {
				AmbleKit.LOGGER.error("Error occurred while loading resource json {}", rawId.toString(), e);
			}
		}
	}

	@Override
	public void syncToClient(class_3222 player) {
		throw new UnsupportedOperationException("Client-side only registry");
	}

	@Override
	public void readFromServer(class_2540 buf) {
		throw new UnsupportedOperationException("Client-side only registry");
	}

	public static BedrockModelRegistry getInstance() {
		return INSTANCE;
	}
}
