package dev.amble.lib.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.animation.AnimatedEntity;
import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class PlayAnimationCommand {
	public static void register(CommandDispatcher<class_2168> dispatcher) {
		dispatcher.register(method_9247(AmbleKit.MOD_ID)
				.requires(source -> source.method_9259(2))
				.then(method_9247("animation").then(method_9244("target", class_2186.method_9309())
						.then(method_9244("id", class_2232.method_9441()).executes(PlayAnimationCommand::execute)))));
	}

	private static int execute(CommandContext<class_2168> context) {
		class_2960 animationId = class_2232.method_9443(context, "id");
		class_1297 target;

		try {
			target = class_2186.method_9313(context, "target");
		} catch (Exception e) {
			context.getSource().method_9213(class_2561.method_43470("Invalid Target, using self."));
			target = context.getSource().method_9228();
		}

		if (!(target instanceof AnimatedEntity animated)) {
			context.getSource().method_9213(class_2561.method_43470("Target is not an AnimatedEntity"));
			return 0;
		}

		animated.playAnimation(BedrockAnimationReference.parse(animationId));

		String name = target.method_5820();
		context.getSource().method_9226(() -> class_2561.method_43470("Playing animation "+ animationId +" on "+ name), true);
		return 1;
	}
}
