package dev.amble.lib.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.skin.PlayerSkinTexturable;
import dev.amble.lib.skin.SkinData;
import dev.amble.lib.skin.SkinTracker;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class SetSkinCommand {
	public static void register(CommandDispatcher<class_2168> dispatcher) {
		dispatcher.register(method_9247(AmbleKit.MOD_ID)
				.requires(source -> source.method_9259(2))
				.then(method_9247("skin").then(method_9244("target", class_2186.method_9309())
								.then(method_9247("clear").executes(SetSkinCommand::executeClear))
								.then(method_9247("slim").then(method_9244("slim", BoolArgumentType.bool())
										.executes(SetSkinCommand::executeSlim).then(method_9244("value", StringArgumentType.greedyString()).executes(SetSkinCommand::executeWithSlim))))
								.then(method_9247("set").then(method_9244("value", StringArgumentType.greedyString())
												.executes(SetSkinCommand::execute))))));
	}

	private static int executeClear(CommandContext<class_2168> context) {
		PlayerSkinTexturable texturable;
		class_1297 entity;

		try {
			entity = class_2186.method_9313(context, "target");

			if (!(entity instanceof PlayerSkinTexturable)) {
				context.getSource().method_9213(class_2561.method_43470("Target is not a PlayerSkinTexturable"));
				return 0;
			}
			texturable = (PlayerSkinTexturable) entity;

		} catch (CommandSyntaxException e) {
			context.getSource().method_9213(class_2561.method_43470("Invalid Target"));
			return 0;
		}

		SkinTracker.getInstance().removeSynced(texturable.method_5667());
		String username = entity.method_5820();
		context.getSource().method_9226(() -> class_2561.method_43470("Cleared skin of "+ username), true);

		return 1;
	}

	private static int executeSlim(CommandContext<class_2168> context) {
		boolean slim = BoolArgumentType.getBool(context, "slim");
		PlayerSkinTexturable texturable;
		class_1297 entity;

		try {
			entity = class_2186.method_9313(context, "target");

			if (!(entity instanceof PlayerSkinTexturable)) {
				context.getSource().method_9213(class_2561.method_43470("Target is not a PlayerSkinTexturable"));
				return 0;
			}
			texturable = (PlayerSkinTexturable) entity;

		} catch (CommandSyntaxException e) {
			context.getSource().method_9213(class_2561.method_43470("Invalid Target"));
			return 0;
		}

		SkinData data = SkinTracker.getInstance().get(texturable.method_5667());
		if (data == null) {
			context.getSource().method_9213(class_2561.method_43470("Target is not disguised."));
			return 0;
		}

		data = data.withSlim(slim);

		SkinTracker.getInstance().putSynced(texturable.method_5667(), data);

		String username = entity.method_5820();
		context.getSource().method_9226(() -> class_2561.method_43470("Set slimness of "+ username +" to " + slim), true);

		return 1;
	}

	private static int execute(CommandContext<class_2168> context) {
		String value = StringArgumentType.getString(context, "value");
		PlayerSkinTexturable texturable;
		class_1297 entity;

		try {
			entity = class_2186.method_9313(context, "target");

			if (!(entity instanceof PlayerSkinTexturable)) {
				context.getSource().method_9213(class_2561.method_43470("Target is not a PlayerSkinTexturable"));
				return 0;
			}
			texturable = (PlayerSkinTexturable) entity;

		} catch (CommandSyntaxException e) {
			context.getSource().method_9213(class_2561.method_43470("Invalid Target"));
			return 0;
		}

		boolean isUrl = value.startsWith("http://") || value.startsWith("https://");

		if (isUrl) {
			SkinData data = SkinData.url(value, false);

			SkinTracker.getInstance().putSynced(texturable.method_5667(), data);

			String username = entity.method_5820();
			context.getSource().method_9226(() -> class_2561.method_43470("Set skin of " + username + " to " + value), true);

			return 1;
		}

		SkinData.username(value, result -> {
			result.upload(entity.method_5667());

			String username = entity.method_5820();
			context.getSource().method_9226(() -> class_2561.method_43470("Set skin of " + username + " to " + value), true);
		});

		return 1;
	}

	private static int executeWithSlim(CommandContext<class_2168> context) {
		String value = StringArgumentType.getString(context, "value");
		boolean slim = BoolArgumentType.getBool(context, "slim");
		PlayerSkinTexturable texturable;
		class_1297 entity;

		try {
			entity = class_2186.method_9313(context, "target");

			if (!(entity instanceof PlayerSkinTexturable)) {
				context.getSource().method_9213(class_2561.method_43470("Target is not a PlayerSkinTexturable"));
				return 0;
			}
			texturable = (PlayerSkinTexturable) entity;

		} catch (CommandSyntaxException e) {
			context.getSource().method_9213(class_2561.method_43470("Invalid Target"));
			return 0;
		}

		boolean isUrl = value.startsWith("http://") || value.startsWith("https://");

		SkinData data = isUrl ? SkinData.url(value, false) : SkinData.username(value, slim);

		SkinTracker.getInstance().putSynced(texturable.method_5667(), data);

		String username = entity.method_5820();
		context.getSource().method_9226(() -> class_2561.method_43470("Set skin of "+ username +" to " + value), true);

		return 1;
	}
}
