package dev.amble.lib.container.impl;

import dev.amble.lib.AmbleKit;
import dev.amble.lib.animation.AnimatedBlockEntity;
import dev.amble.lib.animation.AnimatedInstance;
import dev.amble.lib.animation.client.BedrockBlockEntityRenderer;
import dev.amble.lib.animation.HasBedrockModel;
import dev.amble.lib.util.RegistrationUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import dev.amble.lib.container.RegistryContainer;
import java.lang.reflect.Field;

public interface BlockEntityContainer extends RegistryContainer<class_2591<?>> {
    @Override
    default void postProcessField(class_2960 identifier, class_2591<?> value, Field field) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) return;

        // automagically register bedrock renderer
        if (!field.isAnnotationPresent(HasBedrockModel.class)) return;

	    registerRenderer((class_2591<? extends AnimatedBlockEntity>) value);
    }

    @Environment(EnvType.CLIENT)
    private static void registerRenderer(class_2591<? extends AnimatedBlockEntity> type) {
        BlockEntityRendererRegistry.register(type, BedrockBlockEntityRenderer::new);
    }

    @Override
    default Class<class_2591<?>> getTargetClass() {
        return RegistryContainer.conform(class_2591.class);
    }

    @Override
    default class_2378<class_2591<?>> getRegistry() {
        return class_7923.field_41181;
    }
}
