package dev.amble.lib.container.impl;

import dev.amble.lib.AmbleKit;
import dev.amble.lib.animation.AnimatedEntity;
import dev.amble.lib.animation.AnimatedInstance;
import dev.amble.lib.animation.client.BedrockEntityRenderer;
import dev.amble.lib.animation.HasBedrockModel;
import dev.amble.lib.util.RegistrationUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import dev.amble.lib.container.RegistryContainer;
import java.lang.reflect.Field;

public interface EntityContainer extends RegistryContainer<class_1299<?>> {
	@Override
	default void postProcessField(class_2960 identifier, class_1299<?> value, Field field) {
		if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) return;

		// automagically register bedrock renderer
		if (!field.isAnnotationPresent(HasBedrockModel.class)) return;

		RegistrationUtil.registerBedrockRenderer(value);
	}

	@Override
	default Class<class_1299<?>> getTargetClass() {
		return RegistryContainer.conform(class_1299.class);
	}

	@Override
	default class_2378<class_1299<?>> getRegistry() {
		return class_7923.field_41177;
	}
}
