package dev.amble.lib.container.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import dev.amble.lib.container.RegistryContainer;
import dev.amble.lib.item.AItem;

public abstract class ItemContainer implements RegistryContainer<class_1792> {

    private List<class_1792> items;

    @Override
    public void start(int fields) {
        this.items = new ArrayList<>(fields);
    }

    @Override
    public Class<class_1792> getTargetClass() {
        return class_1792.class;
    }

    @Override
    public class_2378<class_1792> getRegistry() {
        return class_7923.field_41178;
    }

    @Override
    public void postProcessField(class_2960 identifier, class_1792 value, Field field) {
        this.items.add(value);
    }

    @Override
    public void finish() {
        ItemGroupEvents.MODIFY_ENTRIES_ALL.register((group, entries) -> {
            for (class_1792 item : items) {
                class_1761 target = ((AItem) item).amble$group();

                if (target == null)
                    target = this.getDefaultGroup();

                if (target == group)
                    entries.method_45421(item);
            }
        });
    }

    @Nullable public class_1761 getDefaultGroup() {
        return null;
    }
}
