package dev.amble.lib.data;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import com.google.gson.*;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class DirectedBlockPos {

    public static final Codec<DirectedBlockPos> CODEC = RecordCodecBuilder.create(instance -> instance
            .group(class_2338.field_25064.fieldOf("pos").forGetter(DirectedBlockPos::getPos),
                    Codec.BYTE.fieldOf("rotation").forGetter(DirectedBlockPos::getRotation))
            .apply(instance, DirectedBlockPos::create));

    private final class_2338 pos;
    private final byte rotation;

    private DirectedBlockPos(class_2338 pos, byte rotation) {
        this.pos = pos;
        this.rotation = rotation;
    }

    public DirectedBlockPos pos(int x, int y, int z) {
        return this.pos(new class_2338(x, y, z));
    }

    public DirectedBlockPos pos(class_2338 pos) {
        return DirectedBlockPos.create(pos, this.rotation);
    }

    public class_243 offsetPos(float value) {
        class_2338 pos = this.getPos();

        return new class_243(
                pos.method_10263() + value * this.getVector().method_10263(),
                pos.method_10264() + value * this.getVector().method_10264(),
                pos.method_10260() + value * this.getVector().method_10260()
        );
    }

    public DirectedBlockPos offset(int x, int y, int z) {
        return DirectedBlockPos.create(this.pos.method_10069(x, y, z), this.rotation);
    }

    public DirectedBlockPos apply(Function<Integer, Integer> func) {
        return DirectedBlockPos.create(
                new class_2338(func.apply(this.pos.method_10263()), func.apply(this.pos.method_10264()), func.apply(this.pos.method_10260())),
                this.rotation);
    }

    public static DirectedBlockPos create(class_2338 pos, byte rotation) {
        return new DirectedBlockPos(pos, rotation);
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public byte getRotation() {
        return this.rotation;
    }

    public class_2382 getVector() {
        return switch (this.rotation) {
            default -> new class_2382(0, 0, 0);
            case 0 -> class_2350.field_11043.method_10163();
            case 1, 2, 3 -> class_2350.field_11043.method_10163().method_35853(class_2350.field_11034.method_10163());
            case 4 -> class_2350.field_11034.method_10163();
            case 5, 6, 7 -> class_2350.field_11034.method_10163().method_35853(class_2350.field_11035.method_10163());
            case 8 -> class_2350.field_11035.method_10163();
            case 9, 10, 11 -> class_2350.field_11035.method_10163().method_35853(class_2350.field_11039.method_10163());
            case 12 -> class_2350.field_11039.method_10163();
            case 13, 14, 15 -> class_2350.field_11043.method_10163().method_35853(class_2350.field_11035.method_10163());
        };
    }
    public class_2350 toMinecraftDirection() {
        return switch (this.rotation) {
            case 1, 2, 3, 4 -> class_2350.field_11034;
            case 5, 6, 7, 8 -> class_2350.field_11035;
            case 9, 10, 11, 12 -> class_2350.field_11039;
            default -> class_2350.field_11043;
        };
    }

    public DistanceInformation distanceTo(DirectedBlockPos other) {
        double distance = Math.sqrt(this.pos.method_10262(other.pos));
        boolean rotChange = this.rotation != other.rotation;
        return new DistanceInformation(distance, false, rotChange);
    }

    public boolean equals(Object o) {
        if (this == o)
            return true;

        if (!(o instanceof DirectedBlockPos blockPos))
            return false;

        return Objects.equals(this.pos, blockPos.pos) && Objects.equals(this.rotation, blockPos.rotation);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.rotation);
    }

    public String toString() {
        return this.pos + " " + this.rotation;
    }

    public void write(class_2540 buf) {
        buf.method_10807(this.getPos());
        buf.writeByte(this.rotation);
    }

    public static DirectedBlockPos read(class_2540 buf) {
        class_2338 blockPos = buf.method_10811();
        byte rotation = buf.readByte();

        return DirectedBlockPos.create(blockPos, rotation);
    }

    public static Object serializer() {
        return new Serializer();
    }

    private static class Serializer implements JsonDeserializer<DirectedBlockPos>, JsonSerializer<DirectedBlockPos> {

        @Override
        public DirectedBlockPos deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
                throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();

            int x = obj.get("x").getAsInt();
            int y = obj.get("y").getAsInt();
            int z = obj.get("z").getAsInt();
            byte rotation = obj.get("rotation").getAsByte();

            return DirectedBlockPos.create(new class_2338(x, y, z), rotation);
        }

        @Override
        public JsonElement serialize(DirectedBlockPos src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();

            result.addProperty("x", src.getPos().method_10263());
            result.addProperty("y", src.getPos().method_10264());
            result.addProperty("z", src.getPos().method_10260());
            result.addProperty("rotation", src.getRotation());

            return result;
        }
    }
}
