package dev.amble.lib.data;

import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7718;
import net.minecraft.class_7924;
import com.google.gson.*;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class DirectedGlobalPos {

    public static final Codec<DirectedGlobalPos> CODEC = RecordCodecBuilder.create(instance -> instance
            .group(class_1937.field_25178.fieldOf("dimension").forGetter(DirectedGlobalPos::getDimension),
                    class_2338.field_25064.fieldOf("pos").forGetter(DirectedGlobalPos::getPos),
                    Codec.BYTE.fieldOf("rotation").forGetter(DirectedGlobalPos::getRotation))
            .apply(instance, DirectedGlobalPos::create));

    private final class_5321<class_1937> dimension;
    private final class_2338 pos;
    private final byte rotation;

    protected DirectedGlobalPos(class_5321<class_1937> dimension, class_2338 pos, byte rotation) {
        this.dimension = dimension;
        this.pos = pos;

        this.rotation = rotation;
    }

    public DirectedGlobalPos pos(int x, int y, int z) {
        return this.pos(new class_2338(x, y, z));
    }

    public DirectedGlobalPos pos(class_2338 pos) {
        return DirectedGlobalPos.create(this.dimension, pos, this.rotation);
    }

    public DirectedGlobalPos offset(int x, int y, int z) {
        return DirectedGlobalPos.create(this.dimension, this.pos.method_10069(x, y, z), this.rotation);
    }
    public DirectedGlobalPos offset(class_2350 dir) {
        return DirectedGlobalPos.create(this.dimension, this.pos.method_10093(dir), this.rotation);
    }

    public DirectedGlobalPos rotation(byte rotation) {
        return DirectedGlobalPos.create(this.dimension, this.pos, rotation);
    }

    public DirectedGlobalPos world(class_5321<class_1937> world) {
        return DirectedGlobalPos.create(world, this.pos, this.rotation);
    }

    public static DirectedGlobalPos create(class_5321<class_1937> dimension, class_2338 pos, byte rotation) {
        return new DirectedGlobalPos(dimension, pos, rotation);
    }

    public class_5321<class_1937> getDimension() {
        return this.dimension;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public byte getRotation() {
        return this.rotation;
    }
    public float getRotationDegrees() {
        return class_7718.method_45482(this.getRotation());
    }
    public class_2350 getRotationDirection() {
        return class_2350.method_10150(this.getRotationDegrees());
    }

    public class_2382 getVector() {
        return switch (this.rotation) {
            case 0 -> class_2350.field_11043.method_10163();
            case 1, 2, 3 -> class_2350.field_11043.method_10163().method_35853(class_2350.field_11034.method_10163());
            case 4 -> class_2350.field_11034.method_10163();
            case 5, 6, 7 -> class_2350.field_11034.method_10163().method_35853(class_2350.field_11035.method_10163());
            case 8 -> class_2350.field_11035.method_10163();
            case 9, 10, 11 -> class_2350.field_11035.method_10163().method_35853(class_2350.field_11039.method_10163());
            case 12 -> class_2350.field_11039.method_10163();
            case 13, 14, 15 -> class_2350.field_11043.method_10163().method_35853(class_2350.field_11035.method_10163());
            default -> new class_2382(0, 0, 0);
        };
    }

    public DistanceInformation distanceTo(DirectedGlobalPos other) {
        double distance = Math.sqrt(this.pos.method_10262(other.pos));
        boolean dimChange = !this.dimension.equals(other.dimension);
        boolean rotChange = this.rotation != other.rotation;

        return new DistanceInformation(distance, dimChange, rotChange);
    }

    public boolean equals(Object o) {
        if (this == o)
            return true;

        if (!(o instanceof DirectedGlobalPos globalPos))
            return false;

        return Objects.equals(this.dimension, globalPos.dimension) && Objects.equals(this.pos, globalPos.pos)
                && Objects.equals(this.rotation, globalPos.rotation);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.pos, this.rotation);
    }

    public String toString() {
        return this.dimension + " " + this.pos + " " + this.rotation;
    }

    public void write(class_2540 buf) {
        buf.method_44116(this.dimension);
        buf.method_10807(this.pos);
        buf.writeByte(this.rotation);
    }

    public static DirectedGlobalPos read(class_2540 buf) {
        class_5321<class_1937> registryKey = buf.method_44112(class_7924.field_41223);
        class_2338 blockPos = buf.method_10811();
        byte rotation = buf.readByte();

        return DirectedGlobalPos.create(registryKey, blockPos, rotation);
    }

    public class_2487 toNbt() {
        class_2487 compound = class_2512.method_10692(this.pos);
        compound.method_10582("dimension", this.dimension.method_29177().toString());
        compound.method_10567("rotation", this.rotation);

        return compound;
    }

    public static DirectedGlobalPos fromNbt(class_2487 compound) {
        class_2338 pos = class_2512.method_10691(compound);
        class_5321<class_1937> dimension = class_5321.method_29179(class_7924.field_41223,
                new class_2960(compound.method_10558("dimension")));

        byte rotation = compound.method_10571("rotation");
        return DirectedGlobalPos.create(dimension, pos, rotation);
    }

    // TODO: make directedglobalpos use directedblockpos
    public DirectedBlockPos toPos() {
        return DirectedBlockPos.create(this.pos, this.rotation);
    }

    public static int getNextGeneralizedRotation(int rotation) {
        return (rotation + 2) % 16;
    }

    public static int getPreviousGeneralizedRotation(int rotation) {
        return (rotation - 2) % 16;
    }

    public static byte getGeneralizedRotation(int rotation) {
        if (rotation % 2 != 0 && rotation < 15)
            return (byte) (rotation + 1);

        if (rotation == 15)
            return 0;

        return (byte) rotation;
    }
    public static byte getGeneralizedRotation(class_2350 dir) {
        return getGeneralizedRotation(class_7718.method_45481(dir));
    }

    public static String rotationForArrow(int currentRot) {
        return switch (currentRot) {
            case 1, 2, 3 -> "↗";
            case 4 -> "→";
            case 5, 6, 7 -> "↘";
            case 8 -> "↓";
            case 9, 10, 11 -> "↙";
            case 12 -> "←";
            case 13, 14, 15 -> "↖";
            default -> "↑";
        };
    }

    public static byte wrap(byte value, byte max) {
        return (byte) ((value % max + max) % max);
    }

    public static Object serializer() {
        return new Serializer();
    }

    private static class Serializer implements JsonDeserializer<DirectedGlobalPos>, JsonSerializer<DirectedGlobalPos> {

        @Override
        public DirectedGlobalPos deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
                throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();

            class_5321<class_1937> dimension = context.deserialize(obj.get("dimension"), class_5321.class);

            int x = obj.get("x").getAsInt();
            int y = obj.get("y").getAsInt();
            int z = obj.get("z").getAsInt();
            byte rotation = obj.get("rotation").getAsByte();

            return DirectedGlobalPos.create(dimension, new class_2338(x, y, z), rotation);
        }

        @Override
        public JsonElement serialize(DirectedGlobalPos src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();

            result.addProperty("dimension", src.getDimension().method_29177().toString());
            result.addProperty("x", src.getPos().method_10263());
            result.addProperty("y", src.getPos().method_10264());
            result.addProperty("z", src.getPos().method_10260());
            result.addProperty("rotation", src.getRotation());

            return result;
        }
    }
}
