package dev.amble.lib.datagen.loot;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.class_2248;
import dev.amble.lib.container.impl.BlockContainer;
import dev.amble.lib.datagen.util.NoBlockDrop;
import dev.amble.lib.util.ReflectionUtil;


public class AmbleBlockLootTable extends FabricBlockLootTableProvider {
    protected Queue<Class<? extends BlockContainer>> blockClass;

    public AmbleBlockLootTable(FabricDataOutput dataOutput) {
        super(dataOutput);

        this.blockClass = new LinkedList<>();
    }

    @Override
    public void method_10379() {
        // automatic self block drops
        this.blockClass.forEach(clazz -> ReflectionUtil.getAnnotatedValues(clazz, class_2248.class, NoBlockDrop.class, true).forEach(this::process));
    }

    @SafeVarargs
    public final AmbleBlockLootTable withBlocks(Class<? extends BlockContainer>... blockClass) {
        // add all to queue
        this.blockClass.addAll(Arrays.asList(blockClass));

        return this;
    }

    protected void process(class_2248 block, Optional<NoBlockDrop> annotation) {
        this.method_46025(block);


        NoBlockDrop drop = annotation.orElse(null);
        if (drop != null) {
            if (drop.requireSilkTouch()) {
                this.method_46024(block);
            }

            if (drop.slabDrops()) {
                this.method_45980(block);
            }
        }
    }
}
