package dev.amble.lib.datagen.model;

import java.util.*;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.data.client.*;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.container.impl.BlockContainer;
import dev.amble.lib.container.impl.ItemContainer;
import dev.amble.lib.datagen.util.AutomaticModel;
import dev.amble.lib.util.ReflectionUtil;

public class AmbleModelProvider extends FabricModelProvider {

    protected final FabricDataOutput output;

    protected List<Class<? extends BlockContainer>> blockClass = new ArrayList<>();
    protected Queue<Class<? extends ItemContainer>> itemClass = new LinkedList<>();

    public AmbleModelProvider(FabricDataOutput output) {
        super(output);

        this.output = output;
    }

    @Override
    public void generateBlockStateModels(class_4910 generator) {
        this.blockClass.forEach(clazz -> {
            ReflectionUtil.getAnnotatedValues(clazz, class_2248.class, AutomaticModel.class, false).forEach((block, annotation) -> {
                if (!annotation.orElseThrow().justItem()) {
                    generator.method_25641(block);
                }
            });
        });
    }

    @Override
    public void generateItemModels(class_4915 generator) {
        this.blockClass.forEach(clazz -> {
            ReflectionUtil.getAnnotatedValues(clazz, class_2248.class, AutomaticModel.class, false).forEach((block, annotation) -> {
                if (annotation.orElseThrow().justItem()) {
                    registerItem(generator, block.method_8389(), output.getModId());
                }
            });
        });

        this.itemClass.forEach(clazz -> {
            ReflectionUtil.getAnnotatedValues(clazz, class_1792.class, AutomaticModel.class, false).forEach((item, annotation) -> {
                registerItem(generator, item, output.getModId());
            });
        });
    }

    @SafeVarargs
    public final AmbleModelProvider withBlocks(Class<? extends BlockContainer>... blockClass) {
        // add all to queue
        this.blockClass.addAll(Arrays.asList(blockClass));

        return this;
    }

    @SafeVarargs
    public final AmbleModelProvider withItems(Class<? extends ItemContainer>... itemClass) {
        // add all to queue
        this.itemClass.addAll(Arrays.asList(itemClass));

        return this;
    }

    private static class_4942 item(String modid, String parent, class_4945... requiredTextureKeys) {
        return new class_4942(Optional.of(new class_2960(modid, "item/" + parent)), Optional.empty(), requiredTextureKeys);
    }

    private static class_4942 item(class_4945... requiredTextureKeys) {
        return item("minecraft", "generated", requiredTextureKeys);
    }

    private void registerItem(class_4915 generator, class_1792 item, String modid) {
        class_4942 model = item(class_4945.field_23006);
        model.method_25852(class_4941.method_25840(item), createTextureMap(item, modid), generator.field_22844);
    }

    private class_4944 createTextureMap(class_1792 item, String modid) {
        class_2960 texture = new class_2960(modid, "item/" + getItemName(item));
        if (!(doesTextureExist(texture))) {
            texture = AmbleKit.id("item/error");
        }

        return new class_4944().method_25868(class_4945.field_23006, texture);
    }

    private static String getItemName(class_1792 item) {
        return item.method_7876().split("\\.")[2];
    }

    public boolean doesTextureExist(class_2960 texture) {
        return this.output.getModContainer().findPath("assets/" + texture.method_12836() + "/textures/" + texture.method_12832() + ".png").isPresent();
    }
}
