package dev.amble.lib.datagen.recipe;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2960;
import net.minecraft.class_3981;
import net.minecraft.class_7800;
import net.minecraft.class_7803;
import net.minecraft.class_8074;
import net.minecraft.data.server.recipe.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

public class AmbleRecipeProvider extends FabricRecipeProvider {

    private final List<class_2450> shapelessRecipes = new ArrayList<>();
    private final List<class_2447> shapedRecipes = new ArrayList<>();
    private final HashMap<class_8074, class_2960> smithingTransformRecipes = new HashMap<>();
    private final HashMap<class_2450, class_2960> shapelessRecipesWithNameHashMap = new HashMap<>();
    private final HashMap<class_2447, class_2960> shapedRecipesWithNameHashMap = new HashMap<>();
    private final HashMap<class_3981, class_2960> stonecutting = new HashMap<>();
    private final List<class_2454> blasting = new ArrayList<>();

    public AmbleRecipeProvider(FabricDataOutput output) {
        super(output);
    }

    @Override
    public void method_10419(Consumer<class_2444> exporter) {
        for (class_2450 shapelessRecipeJsonBuilder : shapelessRecipes) {
            shapelessRecipeJsonBuilder.method_10431(exporter);
        }

        for (class_2447 shapedRecipeJsonBuilder : shapedRecipes) {
            shapedRecipeJsonBuilder.method_10431(exporter);
        }

        shapelessRecipesWithNameHashMap.forEach((builder, id) -> builder.method_17972(exporter, id));

        smithingTransformRecipes.forEach((smithingTransformRecipeJsonBuilder, identifier) -> smithingTransformRecipeJsonBuilder.method_48537(exporter, identifier));
        shapedRecipesWithNameHashMap.forEach((builder, id) -> builder.method_17972(exporter, id));

        stonecutting.forEach((stonecuttingRecipeJsonBuilder, identifier) -> stonecuttingRecipeJsonBuilder.method_17972(exporter, identifier));

        for (class_2454 cookingRecipeJsonBuilder : blasting) {
            cookingRecipeJsonBuilder.method_10431(exporter);
        }
    }

    public void addShapelessRecipe(class_2450 builder) {
        if (!shapelessRecipes.contains(builder)) {
            shapelessRecipes.add(builder);
        }
    }

    public void addShapelessRecipe(class_2450 builder, class_2960 id) {
        shapelessRecipesWithNameHashMap.put(builder, id);
    }

    public void addSmithingTransformRecipe(class_8074 builder, class_2960 id) {
        smithingTransformRecipes.put(builder, id);
    }

    public void addShapedRecipe(class_2447 builder, class_2960 id) {
        shapedRecipesWithNameHashMap.put(builder, id);
    }

    public void addShapedRecipe(class_2447 builder) {
        if (!shapedRecipes.contains(builder)) {
            shapedRecipes.add(builder);
        }
    }

    public void addStonecutting(class_2248 in, class_2248 out, int count) {
        class_2960 id = getStonecuttingIdentifier(in, out);

        stonecutting.put(class_3981.method_17969(class_1856.method_8091(in), class_7800.field_40634, out, count).method_17970("has_block", class_7803.method_10426(in)), id);
    }

    public void addStonecutting(class_2248 in, class_2248 out) {
        addStonecutting(in, out, 1);
    }

    private class_2960 getStonecuttingIdentifier(class_2248 in, class_2248 out) {
        return new class_2960(this.output.getModId(), fixupBlockKey(in.method_9539()) + "_to_" + fixupBlockKey(out.method_9539()) + "_stonecutting");
    }

    private String fixupBlockKey(String key) {
        return key.substring(key.lastIndexOf(".") + 1);
    }

    public void addBlastFurnaceRecipe(class_2454 cookingBuilder) {
        if (!blasting.contains(cookingBuilder)) {
            blasting.add(cookingBuilder);
        }
    }
}

