package dev.amble.lib.datagen.tag;

import java.util.*;
import java.util.concurrent.CompletableFuture;

import dev.amble.lib.datagen.util.AxeMineable;
import dev.amble.lib.datagen.util.HoeMineable;
import dev.amble.lib.datagen.util.ShovelMineable;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_7225;
import dev.amble.lib.container.impl.BlockContainer;
import dev.amble.lib.datagen.util.PickaxeMineable;
import dev.amble.lib.util.ReflectionUtil;

public class AmbleBlockTagProvider extends FabricTagProvider.BlockTagProvider {
    protected Queue<Class<? extends BlockContainer>> blockClass;

    public AmbleBlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);

        this.blockClass = new LinkedList<>();
    }

    @Override
    protected void method_10514(class_7225.class_7874 wrapperLookup) {
        this.blockClass.forEach(clazz -> {
            FabricTagBuilder pickaxeBuilder = method_10512(class_3481.field_33715);
            HashMap<class_2248, Optional<PickaxeMineable>> pickaxeBlocks = ReflectionUtil.getAnnotatedValues(clazz, class_2248.class, PickaxeMineable.class, false);

            for (class_2248 block : pickaxeBlocks.keySet()) {
                pickaxeBuilder.add(block);
                PickaxeMineable annotation = pickaxeBlocks.get(block).orElseThrow();

                if (annotation.tool() != PickaxeMineable.Tool.NONE) {
                    method_10512(annotation.tool().tag).add(block);
                }
            }
        });
        this.blockClass.forEach(clazz -> {
            FabricTagBuilder pickaxeBuilder = method_10512(class_3481.field_33713);
            HashMap<class_2248, Optional<AxeMineable>> axeBlocks = ReflectionUtil.getAnnotatedValues(clazz, class_2248.class, AxeMineable.class, false);

            for (class_2248 block : axeBlocks.keySet()) {
                pickaxeBuilder.add(block);
                AxeMineable annotation = axeBlocks.get(block).orElseThrow();

                if (annotation.tool() != AxeMineable.Tool.NONE) {
                    method_10512(annotation.tool().tag).add(block);
                }
            }
        });
        this.blockClass.forEach(clazz -> {
            FabricTagBuilder pickaxeBuilder = method_10512(class_3481.field_33714);
            HashMap<class_2248, Optional<HoeMineable>> axeBlocks = ReflectionUtil.getAnnotatedValues(clazz, class_2248.class, HoeMineable.class, false);

            for (class_2248 block : axeBlocks.keySet()) {
                pickaxeBuilder.add(block);
                HoeMineable annotation = axeBlocks.get(block).orElseThrow();

                if (annotation.tool() != HoeMineable.Tool.NONE) {
                    method_10512(annotation.tool().tag).add(block);
                }
            }
        });
        this.blockClass.forEach(clazz -> {
            FabricTagBuilder pickaxeBuilder = method_10512(class_3481.field_33716);
            HashMap<class_2248, Optional<ShovelMineable>> axeBlocks = ReflectionUtil.getAnnotatedValues(clazz, class_2248.class, ShovelMineable.class, false);

            for (class_2248 block : axeBlocks.keySet()) {
                pickaxeBuilder.add(block);
                ShovelMineable annotation = axeBlocks.get(block).orElseThrow();

                if (annotation.tool() != ShovelMineable.Tool.NONE) {
                    method_10512(annotation.tool().tag).add(block);
                }
            }
        });
    }

    @SafeVarargs
    public final AmbleBlockTagProvider withBlocks(Class<? extends BlockContainer>... blockClass) {
        // add all to queue
        this.blockClass.addAll(Arrays.asList(blockClass));

        return this;
    }
}
