package dev.amble.lib.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import dev.amble.lib.api.ICantBreak;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;

@Mixin(class_3225.class)
public class ServerPlayerInteractionManagerMixin {

    @Shadow
    protected class_3218 world;

    @Shadow
    protected class_3222 player;

    @Inject(method = "tryBreakBlock", at = @At(value = "HEAD"), cancellable = true)
    public void ait$tryBreakBlock(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        class_2248 block = this.world.method_8320(pos).method_26204();
        if (block instanceof ICantBreak cantBreak) {
            cantBreak.onTryBreak(this.world, pos, this.world.method_8320(pos), this.player);
            cir.setReturnValue(false);
            cir.cancel();
        }
    }
}
