package dev.amble.lib.mixin.client;

import dev.amble.lib.animation.AnimatedEntity;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4184;
import net.minecraft.class_7094;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_4184.class)
public abstract class CameraMixin {
	@Shadow
	protected abstract void setRotation(float yaw, float pitch);

	@Shadow
	protected abstract void setPos(class_243 pos);

	@Shadow
	protected abstract void moveBy(double x, double y, double z);

	@Shadow
	public abstract float getYaw();

	@Shadow
	public abstract class_243 getPos();

	@Shadow
	public abstract Quaternionf getRotation();

	@Shadow
	protected abstract double clipToSpace(double desiredCameraDistance);

	@Inject(method="update", at=@At("TAIL"))
	private void amble$update(class_1922 area, class_1297 focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
		if (!(focusedEntity instanceof AnimatedEntity animated)) return;

		BedrockAnimationReference ref = animated.getCurrentAnimation();
		if (ref == null) return;

		BedrockAnimation animation = ref.get().orElse(null);
		if (animation == null || !animation.metadata.fpsCamera()) return;

		class_7094 state = animated.getAnimationState();
		if (state == null || animation.isFinished(state)) return;

		double progress = animation.getRunningSeconds(state);

		String cameraPart = thirdPerson ? "camera" : "head";
		if (!animation.boneTimelines.containsKey(cameraPart)) return;

		float yaw;

		if (thirdPerson && animation.metadata.fpsCameraCopiesHead()) {
			yaw = (focusedEntity instanceof class_746 clientPlayer) ? (class_3532.method_17821(tickDelta, clientPlayer.field_6259, clientPlayer.field_6241)) : focusedEntity.method_5791();
		} else {
			yaw = (focusedEntity instanceof class_746 clientPlayer) ? (class_3532.method_17821(tickDelta, clientPlayer.field_6220, clientPlayer.field_6283)) : focusedEntity.method_43078();
		}

		class_243 position = animation.boneTimelines.get(cameraPart).position().resolve(progress);
		float height = cameraPart.equals("head") ? focusedEntity.method_5751() : 0;

		this.setPos(
				new class_243(
				class_3532.method_16436(tickDelta, focusedEntity.field_6014, focusedEntity.method_23317()),
				class_3532.method_16436(tickDelta, focusedEntity.field_6036, focusedEntity.method_23318()) + (thirdPerson ? 0 : height),
				class_3532.method_16436(tickDelta, focusedEntity.field_5969, focusedEntity.method_23321()))
		);

		class_3545<Float, Float> rots = animation.getRotations(cameraPart, (float) progress);
		float animYaw = rots.method_15441();
		float animPitch = rots.method_15442();

		class_243 pos = position.method_1024((float)Math.toRadians(90)).method_1021(-1 / 16F);
		this.setRotation(yaw, 0);
		// todo \/ the clipping causes the camera to break when on ground
		this.moveBy(clipToSpace(pos.field_1352), clipToSpace(pos.field_1351), clipToSpace(pos.field_1350));
		this.setRotation(animYaw + yaw, animPitch);
	}
}
