package dev.amble.lib.mixin.client;

import dev.amble.lib.animation.AnimatedEntity;
import dev.amble.lib.animation.client.AnimationMetadata;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import net.minecraft.class_989;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_989.class)
public class HeldItemFeatureRendererMixin {
	@Inject(method="renderItem", at = @At("HEAD"), cancellable = true)
	private void amblekit$renderItem(class_1309 entity,
	                                 class_1799 stack,
	                                 class_811 transformationMode,
	                                 class_1306 arm,
	                                 class_4587 matrices,
	                                 class_4597 vertexConsumers,
	                                 int light, CallbackInfo ci) {
		if (!(entity instanceof AnimatedEntity animated)) return;

		AnimationMetadata metadata = AnimationMetadata.getFor(animated);
		if (metadata == null || !metadata.hideHandItems()) return;

		ci.cancel();
	}
}
