package dev.amble.lib.mixin.client;

import dev.amble.lib.animation.AnimatedEntity;
import dev.amble.lib.animation.client.AnimationMetadata;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import net.minecraft.class_310;
import net.minecraft.class_5498;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_5498.class)
public class PerspectiveMixin {
    @Inject(method = "isFirstPerson", at = @At("HEAD"), cancellable = true)
    private void animation$isFirstPerson(CallbackInfoReturnable<Boolean> cir) {
	    class_746 player = class_310.method_1551().field_1724;

	    if (!(player instanceof AnimatedEntity animated)) return;

	    AnimationMetadata metadata = AnimationMetadata.getFor(animated);

	    if (metadata == null || metadata.perspective() == null) return;

        cir.setReturnValue(metadata.perspective().isFirstPerson());
    }
    @Inject(method = "isFrontView", at = @At("HEAD"), cancellable = true)
    private void animation$isFrontView(CallbackInfoReturnable<Boolean> cir) {
	    class_746 player = class_310.method_1551().field_1724;

	    if (!(player instanceof AnimatedEntity animated)) return;

	    AnimationMetadata metadata = AnimationMetadata.getFor(animated);

	    if (metadata == null || metadata.perspective() == null) return;

	    cir.setReturnValue(metadata.perspective().isFrontView());
    }
}