package dev.amble.lib.mixin.client;

import dev.amble.lib.animation.AnimatedEntity;
import dev.amble.lib.animation.client.AnimatedEntityModel;
import dev.amble.lib.client.bedrock.BedrockAnimation;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_591.class)
public abstract class PlayerEntityModelMixin<T extends class_1309>
        extends class_572<T> implements AnimatedEntityModel {

    @Unique
    class_630 root;

    public PlayerEntityModelMixin(class_630 root) {
        super(root);
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    public void animation$init(class_630 root, boolean thinArms, CallbackInfo ci) {
        this.root = root;
    }

    @Inject(method = "setAngles(Lnet/minecraft/entity/LivingEntity;FFFFF)V", at = @At("TAIL"))
    public void animation$setAngles(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        if (!(livingEntity instanceof AnimatedEntity player)) return;

		class_591 model = (class_591)(Object)this;
	    model.field_3394.method_17138(model.field_3398);
	    model.field_3482.method_17138(model.field_3397);
	    model.field_3479.method_17138(model.field_3392);
	    model.field_3484.method_17138(model.field_27433);
	    model.field_3486.method_17138(model.field_3401);
	    model.field_3483.method_17138(model.field_3391);

	    if (!BedrockAnimation.IS_RENDERING_PLAYER || BedrockAnimation.IS_RENDERING_HEAD || livingEntity != class_310.method_1551().field_1719) return;

	    field_3394.field_3665 = false;
    }

    @Override
    public class_630 getPart() {
        return this.root;
    }
}