package dev.amble.lib.register.datapack;

import java.util.*;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import dev.amble.lib.AmbleKit;
import dev.amble.lib.api.Identifiable;
import dev.amble.lib.register.Registry;
import dev.amble.lib.util.ServerLifecycleHooks;

/**
 * A registry which is compatible with datapack registering
 */
public abstract class DatapackRegistry<T extends Identifiable> implements Registry {

    protected static final Random RANDOM = new Random();
    protected final HashMap<class_2960, T> REGISTRY = new HashMap<>();

    public abstract T fallback();

    public T register(T schema) {
        return register(schema, schema.id());
    }

    public T register(T schema, class_2960 id) {
        REGISTRY.put(id, schema);
        return schema;
    }

    protected static <T> T getRandom(List<T> elements, Random random, Supplier<T> fallback) {
        if (elements.isEmpty())
            return fallback.get();

        int randomized = random.nextInt(elements.size());

        return elements.get(randomized);
    }

    public T getRandom(Random random) {
        return DatapackRegistry.getRandom(this.toList(), random, this::fallback);
    }

    public T getRandom() {
        return this.getRandom(RANDOM);
    }

    public List<T> getRandom(int count) {
        List<T> list = new ArrayList<>();

        for (int i = 0; i < count; i++) {
            list.add(this.getRandom());
        }

        return list;
    }

    public T get(class_2960 id) {
        return REGISTRY.get(id);
    }
    public T getOrElse(class_2960 id, T fallback) {
        return REGISTRY.getOrDefault(id, fallback);
    }
    public T getOrFallback(class_2960 id) {
        return this.getOrElse(id, this.fallback());
    }
    public Optional<T> getOptional(class_2960 id) {
        return Optional.ofNullable(this.get(id));
    }

    public List<T> toList() {
        return List.copyOf(REGISTRY.values());
    }

    public Iterator<T> iterator() {
        return REGISTRY.values().iterator();
    }

    public int size() {
        return REGISTRY.size();
    }

    public void syncToEveryone() {
        if (ServerLifecycleHooks.get() == null) {
            AmbleKit.LOGGER.warn("ServerLifecycleHooks is null, cannot sync");
            return;
        }

        for (class_3222 player : ServerLifecycleHooks.get().method_3760().method_14571()) {
            this.syncToClient(player);
        }
    }

    public abstract void syncToClient(class_3222 player);

    public abstract void readFromServer(class_2540 buf);

    @Override
    public void onCommonInit() {
        // this.clearCache();
    }

    public void clearCache() {
        REGISTRY.clear();
    }
}
