package dev.amble.lib.util;

import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2743;
import net.minecraft.class_2783;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import dev.amble.lib.data.DirectedGlobalPos;

public class TeleportUtil {
    public static void teleport(class_1309 entity, DirectedGlobalPos pos) {
        teleport(entity, ServerLifecycleHooks.get().method_3847(pos.getDimension()), pos.getPos().method_46558(), pos.getRotationDegrees());
    }
    public static void teleport(class_1309 entity, class_3218 world, class_243 pos, float yaw) {
        world.method_8503().execute(() -> {
            if (entity instanceof class_3222 player) {
                teleportPlayer(player, world, pos, yaw, player.method_36455());
                return;
            }

            teleportNonPlayer(entity, world, pos, yaw, entity.method_36455());
        });
    }
    private static void teleportPlayer(class_3222 player, class_3218 world, class_243 pos, float yaw, float pitch) {
        player.method_14251(world, pos.field_1352, pos.field_1351, pos.field_1350, yaw, pitch);
        player.method_7255(0);
        player.method_6026().forEach(effect -> player.field_13987.method_14364(new class_2783(player.method_5628(), effect)));
        player.field_13987.method_14364(new class_2743(player));
    }
    private static void teleportNonPlayer(class_1309 entity, class_3218 world, class_243 pos, float yaw, float pitch) {
        if (entity.method_37908().method_27983() == world.method_27983()) {
            entity.method_5808(pos.field_1352, pos.field_1351, pos.field_1350, yaw, pitch);
            return;
        }

        entity.method_48105(world, pos.field_1352, pos.field_1351, pos.field_1350, Set.of(), yaw, pitch);
    }
}
