package dev.drtheo.yaar.event.impl;

import dev.drtheo.yaar.event.TEvent;
import dev.drtheo.yaar.event.TEvents;

public abstract class TriStateTEvent<T extends TEvents> implements TEvent.Result<T, TriStateTEvent.Result> {

    protected dev.drtheo.yaar.event.impl.TriStateTEvent.Result result;

    @Override
    public dev.drtheo.yaar.event.impl.TriStateTEvent.Result result() {
        return result;
    }

    @Override
    public void handleAll(Iterable<T> subscribed) {
        for (T e : subscribed) {
            dev.drtheo.yaar.event.impl.TriStateTEvent.Result newRes = TEvent.handleSilent(this, e, () -> this.handle(e), dev.drtheo.yaar.event.impl.TriStateTEvent.Result.PASS);

            if (newRes == dev.drtheo.yaar.event.impl.TriStateTEvent.Result.PASS) continue;

            this.result = newRes;
            break;
        }
    }

    public abstract dev.drtheo.yaar.event.impl.TriStateTEvent.Result handle(T handler);

    public enum Result {
        DENY,
        PASS,
        ALLOW
    }
}
