/*
 * Decompiled with CFR 0.152.
 */
package dev.amble.lib.animation;

import dev.amble.lib.AmbleKit;
import dev.amble.lib.animation.AnimatedInstance;
import dev.amble.lib.client.bedrock.BedrockAnimationReference;
import dev.amble.lib.util.ServerLifecycleHooks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class AnimationTracker {
    private static final AnimationTracker INSTANCE = new AnimationTracker();
    public static final class_2960 SYNC_KEY = AmbleKit.id("animation_sync");
    private final HashMap<UUID, BedrockAnimationReference> animations = new HashMap();
    private final Set<UUID> updated = new HashSet<UUID>();

    public static AnimationTracker getInstance() {
        return INSTANCE;
    }

    public static void init() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> AnimationTracker.getInstance().sync(handler.method_32311()));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            AnimationTracker.initClient();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void initClient() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> AnimationTracker.getInstance().clear());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SYNC_KEY, (client, handler, buf, responseSender) -> AnimationTracker.getInstance().receive(buf));
    }

    @Nullable
    public BedrockAnimationReference get(AnimatedInstance entity) {
        return this.animations.get(entity.method_5667());
    }

    public void add(UUID id, BedrockAnimationReference animation) {
        this.animations.put(id, animation);
        this.sync(this.toBuf(id, animation));
    }

    public void add(AnimatedInstance entity, BedrockAnimationReference animation) {
        this.add(entity.method_5667(), animation);
    }

    public void removeLocal(UUID id) {
        this.animations.remove(id);
    }

    public void removeLocal(AnimatedInstance entity) {
        this.removeLocal(entity.method_5667());
    }

    public void remove(UUID id) {
        this.removeLocal(id);
        this.sync(this.toRemovalBuf(id));
    }

    public void remove(AnimatedInstance entity) {
        this.remove(entity.method_5667());
    }

    public boolean isDirty(AnimatedInstance entity) {
        return this.updated.remove(entity.method_5667());
    }

    private void clear() {
        this.animations.clear();
    }

    private class_2540 toBuf(Map<UUID, BedrockAnimationReference> map) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(map.size());
        for (Map.Entry<UUID, BedrockAnimationReference> entry : map.entrySet()) {
            buf.method_10797(entry.getKey());
            buf.method_10812(entry.getValue().id());
        }
        return buf;
    }

    private class_2540 toBuf() {
        return this.toBuf(this.animations);
    }

    private class_2540 toBuf(UUID id, BedrockAnimationReference animation) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(1);
        buf.method_10797(id);
        buf.method_10812(animation.id());
        return buf;
    }

    private class_2540 toRemovalBuf(UUID id) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(-1);
        buf.method_10797(id);
        return buf;
    }

    private void receive(class_2540 buf) {
        int count = buf.readInt();
        if (count == -1) {
            UUID id = buf.method_10790();
            this.animations.remove(id);
            return;
        }
        for (int i = 0; i < count; ++i) {
            UUID id = buf.method_10790();
            BedrockAnimationReference reference = BedrockAnimationReference.parse(buf.method_10810());
            this.animations.put(id, reference);
            this.updated.add(id);
        }
    }

    public void sync() {
        this.sync(this.toBuf());
    }

    public void sync(class_3222 target) {
        this.sync(this.toBuf(), target);
    }

    private void sync(class_2540 buf) {
        ServerLifecycleHooks.get().method_3760().method_14571().forEach(p -> this.sync(buf, (class_3222)p));
    }

    private void sync(class_2540 buf, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)SYNC_KEY, (class_2540)buf);
    }
}

